# Arbitrary Text Style Transfer with Large Language Models

## Directory structure
This directory contains the outputs and baselines used in our paper.
The structure is as follows:


`input_text_sources` Original input datasets. Sentiment uses yelp, formality uses GYAFC, and the non-standard styles use the reddit writing prompts.


`human_ground_truth` Ground truth transformations for each standard and non-standard style, written by the authors. Each file corresponds to a dataset, and writing-prompts.tsv contains transformations for each different non-standard style.

`outputs` Outputs from our method.


`outputs/sentiment` The outputs from our method on the sentiment task for augmented zero shot (`outputs/sentiment/aug_zero_shot`), few shot (`outputs/sentiment/few_shot`), zero shot (`outputs/sentiment/zero_shot`). Note that these outputs *are not parsed*. That is, they still include the delimiter brackets and any other generated text that follows them. Each of these directories includes a sweep of results along the following parameters:

- Negative to positive, and positive to negative
- Dialog model or LLM
- Each of 4 descriptors that make the text more positive or negative (e.g., "positive", "happy", "optimistic", "chearful")

This directory also inclues outputs for various sizes of GPT-3 (`outputs/sentiment/gpt3`), but does not include the full parameter sweep.


`outputs/nonstandard_styles` The outputs of our method on each of the nonstandard styles, for both zero shot and augmented zero shot. This also includes the "paraphrase" baseline outputs.


`prior_methods` The outputs of prior methods that we compare to, for formality (we only compare to DualRL and Unsupervised Machine Translation with human evaluation) and sentiment (we compare to the many more with automatic evaluation.)


## Visualizer
Browse some of these outputs [here](https://bit.ly/3fLDuci)