## Codebase: On the Certified Robustness for Ensemble Models and Beyond

This code repo contains codebase for our proposed DRT-certified robust ensemble training. We also include other STOA baseline code for comparison.



#### Certified ensemble robustness

* Gaussian smoothing (https://arxiv.org/abs/1902.02918)
* SmoothAdv Training (https://arxiv.org/pdf/1906.04584.pdf)
* MACER Training (https://openreview.net/forum?id=rJx1Na4Fwr)
* Stability Training (https://arxiv.org/pdf/1809.03113.pdf)
* **DRT** (ours)

`train/Certified` folder contains corresponding code to construct above certified robust ensemble models. You can use the command as

`python train/Certified/train_xxx.py **kwargs`

`**kwargs` refers to the training parameters which is defined in each training code file.

`eval/Certified` folder contains:

* `certify_mme.py`: Certify given smoothing ensemble model's robustness with Max Margin Ensemble protocol and create per instance records.
* `certify_we.py`: Certify given smoothing ensemble model's robustness with Weighted Ensemble protocol  and create per instance records.
* `summary.py`: Compute the certified accuracy with each radius based on given per instance certification record file.

`utils/Empirical` folder contains:

* `script_gen.py`: Generate the training script conveniently with corresponding configuration. (Under refinement)
* `utils_ensemble.py`: Useful training procedure recorder for smoothing ensemble training.

