# Smoothness Control Term for Graph Neural Networks

<p><mark>Review:</mark> Code marked for submission review.</p>

# Configuration

## Installation
Recommended environment is used in `Dockerfile`.
```bash
nvidia-docker build --rm -t sct_gnn .
```

The `sct_gnn` library can be installed using `pip` or `pip3` 
``` bash
pip3 install -e .
```

The load and save configuration for the examples and tasks is configured for the following structure.
```
/root
└── workspace
    ├── data
    ├── sct-gnn
    └── out
```


## Data

All datasets are retrieved at runtime from graph learning benchmarks.

# Reproducibility

**Tasks**

All task files are found in the `sct_gnn/tasks/` and can be called using `hydra-core` options. For details on the available options use flag `--help`.

```bash
python3 tasks/pyg-planetoid-public.py --help
```

**Examples**

Additional examples are located in the `sct_gnn/examples/`. 

```bash
python3 ./examples/data_stats.py
```