# Universal Sleep Decoder

Universal Sleep Decoder (USD) is a general framework for decoding neural signals during NREM sleep, even on unseen subjects in a zero-shot manner.

The data for this project will be released to the public, but is not included in the zip file. So most of the code that depends on this data will not run. But, for completion, we provide the training and fine-tuning pipeline instructions.

## Input
It is expected that the input is EEG data that has been average re-referenced.

## Individual training
First, you need to create conda environment, then activate it:

```
conda env create -f environment-train.yml
conda activate eeg2labal-train
```

To re-produce the results in Fig.3. You can directly run:

```
cd ./train && python naive_cnn.py
```

```
cd ./train && python naive_transformer.py
```

```
cd ./train && python roformer.py
```

```
cd ./train/domain_adaptation/DomainContrastiveNet/unisubject && python SubdomainContrastiveConvNet.py
```

```
cd ./train/domain_adaptation/DomainContrastiveNet/unisubject && python SubdomainContrastiveTransformer.py
```

```
cd ./train/domain_adaptation/DomainContrastiveNet/unisubject && python SubdomainContrastiveRoformer.py
```


## USD pre-training
```
python train/EEG_Pretrain_Sleep_cnn.py
```

```
python train/EEG_Pretrain_Awake_Sleep_cnn.py
```

```
python train/EEG_Pretrain_Sleep_transformer.py
```

```
python train/EEG_Pretrain_Awake_Sleep_transformer.py
```

## USD fine-tuning
```
python train/EEG_Finetune_Sleep_cnn.py
```

```
python train/EEG_Finetune_Awake_Sleep_cnn.py
```

```
python train/EEG_Finetune_Sleep_transformer.py
```

```
python train/EEG_Finetune_Awake_Sleep_transformer.py
```

