#!/usr/bin/env python3
"""
Created on 19:15, Aug. 1st, 2023

@author: Anonymous
"""
import tensorflow as tf
# local dep
if __name__ == "__main__":
    import os, sys
    sys.path.insert(0, os.pardir)
from utils import DotDict

__all__ = [
    "clip_cnn_params",
]

class clip_cnn_params(DotDict):
    """
    This contains one single object that generates a dictionary of parameters,
    which is provided to `clip_cnn` on initialization.
    """
    # Internal macro parameter.
    _precision = "float32"

    def __init__(self, dataset="eeg_anonymous"):
        """
        Initialize `clip_cnn_params` object.
        """
        ## First call super class init function to set up `DotDict`
        ## style object and inherit it's functionality.
        super(clip_cnn_params, self).__init__()

        ## Generate all parameters hierarchically.
        # -- Model parameters
        self.model = clip_cnn_params._gen_model_params(dataset)
        # -- Training parameters
        self.train = clip_cnn_params._gen_train_params(dataset)

        ## Do init iteration.
        clip_cnn_params.iteration(self, 0)

    """
    update funcs
    """
    # def iteration func
    def iteration(self, iteration):
        """
        Update parameters at every backpropagation iteration/gradient update.
        """
        ## -- Train parameters
        # Calculate current learning rate.
        self.train.lr_i = self.train.lr

    """
    generate funcs
    """
    ## def _gen_model_* funcs
    # def _gen_model_params func
    @staticmethod
    def _gen_model_params(dataset):
        """
        Generate model parameters.
        """
        # Initialize `model_params`.
        model_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        model_params.dataset = dataset
        # Precision parameter.
        model_params.precision = getattr(tf, clip_cnn_params._precision)\
            if hasattr(tf, clip_cnn_params._precision) else tf.float32
        # The number of modalities.
        model_params.n_modalities = 2
        # The dimension of contrastive layer.
        model_params.d_contra = 128
        # The mode of contrastive loss calculation.
        model_params.contra_loss_mode = ["clip", "clip_orig", "unicl"][-1]
        # The mode of contrastive prediction.
        model_params.contra_pred_mode = ["max_z", "prob_z", "max_y", "prob_y"][-1]
        # The ratio of contrastive prediction.
        model_params.contra_pred_ratio = 0.
        # The ratio of contrastive loss.
        model_params.contra_loss_ratio = 0.5
        # The scale factor of contrastive loss.
        model_params.contra_loss_scale = 0.1
        # Normal parameters related to eeg_anonymous dataset.
        if model_params.dataset == "eeg_anonymous":
            # The size of input channels.
            model_params.n_channels = 55
            # The size of output classes.
            model_params.n_labels = 15
        # Normal parameters related to other dataset.
        else:
            # The size of input channels.
            model_params.n_channels = 55
            # The size of output classes.
            model_params.n_labels = 15
        ## -- CNN parameters
        model_params.cnn = clip_cnn_params._gen_model_cnn_params(model_params)
        ## -- Classification parameters
        model_params.cls = clip_cnn_params._gen_model_cls_params(model_params)

        # Return the final `model_params`.
        return model_params

    # def _gen_model_cnn_params func
    @staticmethod
    def _gen_model_cnn_params(model_params):
        """
        Generate model.cnn parameters.
        """
        # Initialize `model_cnn_params`.
        model_cnn_params = DotDict()

        ## -- Normal parameters (related to Conv1d)
        # Normal parameters related to eeg_anonymous dataset.
        if model_params.dataset == "eeg_anonymous":
            # The dimension of input vector.
            model_cnn_params.d_input = model_params.n_channels
            # The number of filters of each CNN layer.
            model_cnn_params.n_filters = [256, 128]
            # The size of kernel of each CNN layer.
            model_cnn_params.d_kernel = [9, 11]
            # The length of stride of each CNN layer.
            model_cnn_params.strides = [1, 1]
            # The length of padding of each CNN layer.
            model_cnn_params.padding = ["same", "same"]
            # The dilation rate of each CNN layer.
            model_cnn_params.dilation_rate = [1, 2]
            ## -- Normal parameters (related to MaxPool1d)
            # The size of max pooling kernel of each CNN layer.
            model_cnn_params.d_pooling_kernel = 2
            ## -- Normal parameters (related to Dropout)
            # The dropout rate of dropout layer.
            model_cnn_params.dropout = 0.5
        # Normal parameters related to other dataset.
        else:
            # The dimension of input vector.
            model_cnn_params.d_input = model_params.n_channels
            # The number of filters of each CNN layer.
            model_cnn_params.n_filters = [256, 128]
            # The size of kernel of each CNN layer.
            model_cnn_params.d_kernel = [9, 11]
            # The length of stride of each CNN layer.
            model_cnn_params.strides = [1, 1]
            # The length of padding of each CNN layer.
            model_cnn_params.padding = ["same", "same"]
            # The dilation rate of each CNN layer.
            model_cnn_params.dilation_rate = [1, 2]
            ## -- Normal parameters (related to MaxPool1d)
            # The size of max pooling kernel of each CNN layer.
            model_cnn_params.d_pooling_kernel = 2
            ## -- Normal parameters (related to Dropout)
            # The dropout rate of dropout layer.
            model_cnn_params.dropout = 0.5

        # Return the final `model_cnn_params`.
        return model_cnn_params

    # def _gen_model_cls_params func
    @staticmethod
    def _gen_model_cls_params(model_params):
        """
        Generate model.cls parameters.
        """
        # Initialize `model_cls_params`.
        model_cls_params = DotDict()

        ## -- Normal parameters
        # Normal parameters related to eeg_anonymous dataset.
        if model_params.dataset == "eeg_anonymous":
            # The dimensions of the hidden layer in classification block.
            model_cls_params.d_hidden = [128,]
            # The dropout probability of the hidden layer in classification block.
            model_cls_params.dropout = 0.
        # Normal parameters related to other dataset.
        else:
            # The dimensions of the hidden layer in classification block.
            model_cls_params.d_hidden = [128,]
            # The dropout probability of the hidden layer in classification block.
            model_cls_params.dropout = 0.
        # The dimension of classification layer in classification block.
        model_cls_params.d_output = model_params.n_labels

        # Return the final `model_cls_params`.
        return model_cls_params

    ## def _gen_train_* funcs
    # def _gen_train_params func
    @staticmethod
    def _gen_train_params(dataset):
        """
        Generate training parameters.
        """
        # Initialize `train_params`.
        train_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        train_params.dataset = dataset
        # Precision parameter.
        train_params.precision = getattr(tf, clip_cnn_params._precision)\
            if hasattr(tf, clip_cnn_params._precision) else tf.float32
        # Whether use graph mode or eager mode.
        train_params.use_graph_mode = True
        # The ratio of train dataset. The rest is test dataset.
        train_params.train_ratio = 0.8
        # Size of buffer used in shuffle.
        train_params.buffer_size = int(1e4)
        ## -- Dataset-specific parameters
        # Normal parameters related to eeg_anonymous dataset.
        if train_params.dataset == "eeg_anonymous":
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 256
            # The learning rate of training process.
            train_params.lr = 3e-4
        # Normal parameters related to other dataset.
        else:
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 128
            # The learning rate of training process.
            train_params.lr = 3e-4

        # Return the final `train_params`.
        return train_params

if __name__ == "__main__":
    # Instantiate `clip_cnn_params`.
    clip_cnn_params_inst = clip_cnn_params(dataset="eeg_anonymous")

