#!/usr/bin/env python3
"""
Created on 16:59, Jul. 31st, 2023

@author: Anonymous
"""
import tensorflow as tf
# local dep
if __name__ == "__main__":
    import os, sys
    sys.path.insert(0, os.pardir)
from utils import DotDict

__all__ = [
    "clip_transformer_params",
]

class clip_transformer_params(DotDict):
    """
    This contains one single object that generates a dictionary of parameters,
    which is provided to `mae` on initialization.
    """
    # Initialize macro parameter.
    _precision = "float32"

    def __init__(self, dataset="eeg_anonymous"):
        """
        Initialize `clip_transformer_params`.
        """
        ## First call super class init function to set up `DotDict`
        ## style object and inherit it's functionality.
        super(clip_transformer_params, self).__init__()

        ## Generate all parameters hierarchically.
        # -- Model parameters
        self.model = clip_transformer_params._gen_model_params(dataset)
        # -- Train parameters
        self.train = clip_transformer_params._gen_train_params(dataset)

        ## Do init iteration.
        clip_transformer_params.iteration(self, 0)

    """
    update funcs
    """
    # def iteration func
    def iteration(self, iteration):
        """
        Update parameters at every backpropagation iteration/gradient update.
        """
        ## -- Train parameters
        # Calculate current learning rate.
        self.train.lr_i = self.train.lr

    """
    generate funcs
    """
    ## def _gen_model_* funcs
    # def _gen_model_params func
    @staticmethod
    def _gen_model_params(dataset):
        """
        Generate model parameters.
        """
        # Initialize `model_params`.
        model_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        model_params.dataset = dataset
        # Precision parameter.
        model_params.precision = getattr(tf, clip_transformer_params._precision)\
            if hasattr(tf, clip_transformer_params._precision) else tf.float32
        # The number of modalities.
        model_params.n_modalities = 2
        # The dimension of contrastive layer.
        model_params.d_contra = 128
        # The mode of contrastive prediction.
        model_params.contra_pred_mode = ["max_z", "prob_z", "max_y", "prob_y"][-1]
        # The ratio of contrastive prediction.
        model_params.contra_pred_ratio = 0.
        # The ratio of contrastive loss.
        model_params.contra_loss_ratio = 0.05
        # The scale factor of contrastive loss.
        model_params.contra_loss_scale = 1.
        ## -- Dataset-specific parameters
        # Normal parameters related to eeg_anonymous dataset.
        if model_params.dataset == "eeg_anonymous":
            # The number of output classes.
            model_params.n_labels = 15
        # Normal parameters related to other dataset.
        else:
            # The number of output classes.
            model_params.n_labels = 15
        ## -- Encoder parameters
        model_params.encoder = clip_transformer_params._gen_model_encoder_params(model_params)
        ## -- Classification parameters
        model_params.cls = clip_transformer_params._gen_model_cls_params(model_params)

        # Return the final `model_params`.
        return model_params

    # def _gen_model_encoder_params func
    @staticmethod
    def _gen_model_encoder_params(model_params):
        """
        Generate model.encoder parameters.
        """
        # Initialize `model_encoder_params`.
        model_encoder_params = DotDict()

        ## -- Normal parameters
        # Normal parameters related to eeg_anonymous dataset.
        if model_params.dataset == "eeg_anonymous":
            # The dimensions of the embedding.
            model_encoder_params.d_model = 128
            # The maximum length of element sequence.
            model_encoder_params.max_len = 80
            # The number of attention blocks.
            model_encoder_params.n_blocks = 2
            # The number of attention heads.
            model_encoder_params.n_heads = 8
            # The dimensions of attention head.
            model_encoder_params.d_head = 64
            # The dropout probability of attention weights.
            model_encoder_params.mha_dropout_prob = 0.
            # The dimensions of the hidden layer in ffn.
            model_encoder_params.d_ff = 128
            # The dropout probability of the hidden layer in ffn.
            model_encoder_params.ff_dropout_prob = [0., 0.3]
        # Normal parameters related to other dataset.
        else:
            # The dimensions of the embedding.
            model_encoder_params.d_model = 128
            # The maximum length of element sequence.
            model_encoder_params.max_len = 80
            # The number of attention blocks.
            model_encoder_params.n_blocks = 2
            # The number of attention heads.
            model_encoder_params.n_heads = 8
            # The dimensions of attention head.
            model_encoder_params.d_head = 64
            # The dropout probability of attention weights.
            model_encoder_params.mha_dropout_prob = 0.
            # The dimensions of the hidden layer in ffn.
            model_encoder_params.d_ff = 128
            # The dropout probability of the hidden layer in ffn.
            model_encoder_params.ff_dropout_prob = [0., 0.3]

        # Return the final `model_encoder_params`.
        return model_encoder_params

    # def _gen_model_cls_params func
    @staticmethod
    def _gen_model_cls_params(model_params):
        """
        Generate model.cls parameters.
        """
        # Initialize `model_cls_params`.
        model_cls_params = DotDict()

        ## -- Normal parameters
        # Normal parameters related to eeg_anonymous dataset.
        if model_params.dataset == "eeg_anonymous":
            # The dimensions of the hidden layer in classification block.
            model_cls_params.d_hidden = [128,]
            # The dropout probability of the hidden layer in classification block.
            model_cls_params.dropout = 0.
        # Normal parameters related to other dataset.
        else:
            # The dimensions of the hidden layer in classification block.
            model_cls_params.d_hidden = [128,]
            # The dropout probability of the hidden layer in classification block.
            model_cls_params.dropout = 0.
        # The dimension of classification layer in classification block.
        model_cls_params.d_output = model_params.n_labels

        # Return the final `model_cls_params`.
        return model_cls_params

    ## def _gen_train_* funcs
    # def _gen_train_params func
    @staticmethod
    def _gen_train_params(dataset):
        """
        Generate train parameters.
        """
        # Initialize `train_params`.
        train_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        train_params.dataset = dataset
        # Precision parameter.
        train_params.precision = getattr(tf, clip_transformer_params._precision)\
            if hasattr(tf, clip_transformer_params._precision) else tf.float32
        # Whether use graph mode or eager mode.
        train_params.use_graph_mode = True
        # The ratio of train dataset. The rest is test dataset.
        train_params.train_ratio = 0.8
        # Size of buffer used in shuffle.
        train_params.buffer_size = int(1e4)
        ## -- Dataset-specific parameters
        # Normal parameters related to eeg_anonymous dataset.
        if train_params.dataset == "eeg_anonymous":
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 128
            # The learning rate of training process.
            train_params.lr = 5e-5
        # Normal parameters related to other dataset.
        else:
            # Number of epochs used in training process.
            train_params.n_epochs = 20
            # Number of batch size used in training process.
            train_params.batch_size = 32
            # The learning rate of training process.
            train_params.lr = 3e-4

        # Return the final `train_params`.
        return train_params

if __name__ == "__main__":
    # Instantiate `clip_transformer_params`.
    clip_transformer_params_inst = clip_transformer_params(dataset="eeg_anonymous")

