#!/usr/bin/env python3
"""
Created on 17:49, Jul. 8th, 2023

@author: Anonymous
"""
import tensorflow as tf
# local dep
if __name__ == "__main__":
    import os, sys
    sys.path.insert(0, os.pardir)
from utils import DotDict

__all__ = [
    "naive_rnn_params",
]

class naive_rnn_params(DotDict):
    """
    This contains one single object that generates a dictionary of parameters,
    which is provided to `naive_rnn` on initialization.
    """
    # Internal macro parameter.
    _precision = "float32"

    def __init__(self, dataset="eeg_palazzo2020decoding"):
        """
        Initialize `naive_rnn_params` object.
        """
        ## First call super class init function to set up `DotDict`
        ## style object and inherit it's functionality.
        super(naive_rnn_params, self).__init__()

        ## Generate all parameters hierarchically.
        # -- Model parameters
        self.model = naive_rnn_params._gen_model_params(dataset)
        # -- Training parameters
        self.train = naive_rnn_params._gen_train_params(dataset)

        ## Do init iteration.
        naive_rnn_params.iteration(self, 0)

    """
    update funcs
    """
    # def iteration func
    def iteration(self, iteration):
        """
        Update parameters at every backpropagation iteration/gradient update.
        """
        ## -- Model parameters.
        # Calculate current learning rate.
        self.model.lr_i = self.model.lr

    """
    generate funcs
    """
    ## def _gen_model_* funcs
    # def _gen_model_params func
    @staticmethod
    def _gen_model_params(dataset):
        """
        Generate model parameters.
        """
        # Initialize `model_params`.
        model_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        model_params.dataset = dataset
        # Normal parameters related to eeg_palazzo2020decoding dataset.
        if model_params.dataset == "eeg_palazzo2020decoding":
            # The size of input channels.
            model_params.n_channels = 128
            # The size of output classes.
            model_params.n_labels = 40
            # The learning rate of optimizer.
            model_params.lr = 3e-4
        # Normal parameters related to eeg_anonymous dataset.
        elif model_params.dataset == "eeg_anonymous":
            # The size of input channels.
            model_params.n_channels = 55
            # The size of output classes.
            model_params.n_labels = 15
            # The learning rate of optimizer.
            model_params.lr = 3e-4
        # Normal parameters related to other dataset.
        else:
            # The size of input channels.
            model_params.n_channels = 128
            # The size of output classes.
            model_params.n_labels = 40
            # The learning rate of optimizer.
            model_params.lr = 3e-4
        ## -- RNN parameters
        model_params.rnn = naive_rnn_params._gen_model_rnn_params(model_params)
        ## -- Fully connect parameters
        model_params.fc = naive_rnn_params._gen_model_fc_params(model_params)

        # Return the final `model_params`.
        return model_params

    # def _gen_model_rnn_params func
    @staticmethod
    def _gen_model_rnn_params(model_params):
        """
        Generate model.rnn parameters.
        """
        # Initialize `model_rnn_params`.
        model_rnn_params = DotDict()

        ## -- Normal parameters (related to RNN)
        # Normal parameters related to eeg_palazzo2020decoding dataset.
        if model_params.dataset == "eeg_palazzo2020decoding":
            # The type of rnn layer.
            model_rnn_params.model = "LSTM"
            # The dimension of input vector.
            model_rnn_params.d_input = model_params.n_channels
            # The number of units of each RNN layer.
            model_rnn_params.n_units = [128, 128,]
            # The dropout ratio of each RNN layer.
            model_rnn_params.dropout = [0., 0.,]
            # The recurrent dropout ratio of each RNN layer.
            model_rnn_params.recurrent_dropout = [0., 0.,]
        # Normal parameters related to eeg_anonymous dataset.
        elif model_params.dataset == "eeg_anonymous":
            # The type of rnn layer.
            model_rnn_params.model = "LSTM"
            # The dimension of input vector.
            model_rnn_params.d_input = model_params.n_channels
            # The number of units of each RNN layer.
            model_rnn_params.n_units = [128, 128,]
            # The dropout ratio of each RNN layer.
            model_rnn_params.dropout = [0., 0.,]
            # The recurrent dropout ratio of each RNN layer.
            model_rnn_params.recurrent_dropout = [0., 0.,]
        # Normal parameters related to other dataset.
        else:
            # The type of rnn layer.
            model_rnn_params.model = "LSTM"
            # The dimension of input vector.
            model_rnn_params.d_input = model_params.n_channels
            # The number of units of each RNN layer.
            model_rnn_params.n_units = [128, 128,]
            # The dropout ratio of each RNN layer.
            model_rnn_params.dropout = [0., 0.,]
            # The recurrent dropout ratio of each RNN layer.
            model_rnn_params.recurrent_dropout = [0., 0.,]

        # Return the final `model_rnn_params`.
        return model_rnn_params

    # def _gen_model_fc_params func
    @staticmethod
    def _gen_model_fc_params(model_params):
        """
        Generate model.fc parameters.
        """
        # Initialize `model_fc_params`.
        model_fc_params = DotDict()

        ## -- Normal parameters
        # Normal parameters related to eeg_palazzo2020decoding dataset.
        if model_params.dataset == "eeg_palazzo2020decoding":
            # The dimensions of hidden layers.
            model_fc_params.d_hidden = [128,]
            # The dropout rate of dropout layer.
            model_fc_params.dropout = 0.
        # Normal parameters related to eeg_anonymous dataset.
        elif model_params.dataset == "eeg_anonymous":
            # The dimensions of hidden layers.
            model_fc_params.d_hidden = [128,]
            # The dropout rate of dropout layer.
            model_fc_params.dropout = 0.5
        # Normal parameters related to other dataset.
        else:
            # The dimensions of hidden layers.
            model_fc_params.d_hidden = [128,]
            # The dropout rate of dropout layer.
            model_fc_params.dropout = 0.
        # The dimension of output vector.
        model_fc_params.d_output = model_params.n_labels

        # Return the final `model_fc_params`.
        return model_fc_params

    ## def _gen_train_* funcs
    # def _gen_train_params func
    @staticmethod
    def _gen_train_params(dataset):
        """
        Generate training parameters.
        """
        # Initialize `train_params`.
        train_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        train_params.dataset = dataset
        # Precision parameter.
        train_params.precision = getattr(tf, naive_rnn_params._precision)\
            if hasattr(tf, naive_rnn_params._precision) else tf.float32
        # Whether use graph mode or eager mode.
        train_params.use_graph_mode = True
        # The ratio of train dataset. The rest is test dataset.
        train_params.train_ratio = 0.8
        # Size of buffer used in shuffle.
        train_params.buffer_size = int(1e4)
        ## -- Dataset-specific parameters
        # Normal parameters related to eeg_palazzo2020decoding dataset.
        if train_params.dataset == "eeg_palazzo2020decoding":
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 16
        # Normal parameters related to eeg_anonymous dataset.
        elif train_params.dataset == "eeg_anonymous":
            # Number of epochs used in training process.
            train_params.n_epochs = 50
            # Number of batch size used in training process.
            train_params.batch_size = 16
        # Normal parameters related to other dataset.
        else:
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 16

        # Return the final `train_params`.
        return train_params

if __name__ == "__main__":
    # Instantiate `naive_rnn_params`.
    naive_rnn_params_inst = naive_rnn_params(dataset="eeg_palazzo2020decoding")

