#!/usr/bin/env python3
"""
Created on 14:26, Jun. 28th, 2023

@author: Anonymous
"""
import tensorflow as tf
# local dep
if __name__ == "__main__":
    import os, sys
    sys.path.insert(0, os.pardir)
from utils import DotDict

__all__ = [
    "naive_transformer_params",
]

class naive_transformer_params(DotDict):
    """
    This contains one single object that generates a dictionary of parameters,
    which is provided to `mae` on initialization.
    """
    # Initialize macro parameter.
    _precision = "float32"

    def __init__(self, dataset="meg_anonymous"):
        """
        Initialize `naive_transformer_params`.
        """
        ## First call super class init function to set up `DotDict`
        ## style object and inherit it's functionality.
        super(naive_transformer_params, self).__init__()

        ## Generate all parameters hierarchically.
        # -- Model parameters
        self.model = naive_transformer_params._gen_model_params(dataset)
        # -- Train parameters
        self.train = naive_transformer_params._gen_train_params(dataset)

        ## Do init iteration.
        naive_transformer_params.iteration(self, 0)

    """
    update funcs
    """
    # def iteration func
    def iteration(self, iteration):
        """
        Update parameters at every backpropagation iteration/gradient update.
        """
        ## -- Train parameters
        # Calculate current learning rate.
        self.train.lr_i = self.train.lr

    """
    generate funcs
    """
    ## def _gen_model_* funcs
    # def _gen_model_params func
    @staticmethod
    def _gen_model_params(dataset):
        """
        Generate model parameters.
        """
        # Initialize `model_params`.
        model_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        model_params.dataset = dataset
        # Precision parameter.
        model_params.precision = getattr(tf, naive_transformer_params._precision)\
            if hasattr(tf, naive_transformer_params._precision) else tf.float32
        ## -- Dataset-specific parameters
        # Normal parameters related to eeg_anonymous dataset.
        if model_params.dataset == "eeg_anonymous":
            # The dimensions of the embedding.
            model_params.d_model = 256
            # The maximum length of element sequence.
            model_params.max_len = 80
            # The depth of encoder.
            model_params.encoder_depth = 2
            # The number of attention heads.
            model_params.n_heads = 8
            # The dimensions of attention head.
            model_params.d_head = 128
            # The dropout probability of attention weights.
            model_params.mha_dropout_prob = 0.
            # The dimensions of the hidden layer in ffn.
            model_params.d_ff = 256
            # The dropout probability of the hidden layer in ffn.
            model_params.ff_dropout_prob = [0., 0.3]
            # The dimensions of the hidden layer in fc block.
            model_params.d_fc = 128
            # The dropout probability of the hidden layer in fc block.
            model_params.fc_dropout_prob = 0.
            # The number of output classes.
            model_params.n_labels = 15
        # Normal parameters related to meg_anonymous dataset.
        elif model_params.dataset == "meg_anonymous":
            # The dimensions of the embedding.
            model_params.d_model = 64
            # The maximum length of element sequence.
            model_params.max_len = 80
            # The depth of encoder.
            model_params.encoder_depth = 8
            # The number of attention heads.
            model_params.n_heads = 6
            # The dimensions of attention head.
            model_params.d_head = 32
            # The dropout probability of attention weights.
            model_params.mha_dropout_prob = 0.
            # The dimensions of the hidden layer in ffn.
            model_params.d_ff = 64
            # The dropout probability of the hidden layer in ffn.
            model_params.ff_dropout_prob = [0., 0.5]
            # The dimensions of the hidden layer in fc block.
            model_params.d_fc = 128
            # The dropout probability of the hidden layer in fc block.
            model_params.fc_dropout_prob = 0.
            # The number of output classes.
            model_params.n_labels = 15
        # Normal parameters related to seeg_he2023xuanwu dataset.
        elif model_params.dataset == "seeg_he2023xuanwu":
            # The dimensions of the embedding.
            model_params.d_model = 64
            # The maximum length of element sequence.
            model_params.max_len = 240
            # The depth of encoder.
            model_params.encoder_depth = 12
            # The number of attention heads.
            model_params.n_heads = 6
            # The dimensions of attention head.
            model_params.d_head = 32
            # The dropout probability of attention weights.
            model_params.mha_dropout_prob = 0.
            # The dimensions of the hidden layer in ffn.
            model_params.d_ff = 64
            # The dropout probability of the hidden layer in ffn.
            model_params.ff_dropout_prob = [0., 0.5]
            # The dimensions of the hidden layer in fc block.
            model_params.d_fc = 128
            # The dropout probability of the hidden layer in fc block.
            model_params.fc_dropout_prob = 0.
            # The number of output classes.
            model_params.n_labels = 61
        # Normal parameters related to other dataset.
        else:
            # The dimensions of the embedding.
            model_params.d_model = 64
            # The maximum length of element sequence.
            model_params.max_len = 600
            # The depth of encoder.
            model_params.encoder_depth = 2
            # The number of attention heads.
            model_params.n_heads = 4
            # The dimensions of attention head.
            model_params.d_head = 64
            # The dropout probability of attention weights.
            model_params.mha_dropout_prob = 0.
            # The dimensions of the hidden layer in ffn.
            model_params.d_ff = 64
            # The dropout probability of the hidden layer in ffn.
            model_params.ff_dropout_prob = [0., 0.]
            # The dimensions of the hidden layer in fc block.
            model_params.d_fc = 64
            # The dropout probability of the hidden layer in fc block.
            model_params.fc_dropout_prob = 0.
            # The number of output classes.
            model_params.n_labels = 10

        # Return the final `model_params`.
        return model_params

    ## def _gen_train_* funcs
    # def _gen_train_params func
    @staticmethod
    def _gen_train_params(dataset):
        """
        Generate train parameters.
        """
        # Initialize `train_params`.
        train_params = DotDict()

        ## -- Normal parameters
        # The type of dataset.
        train_params.dataset = dataset
        # Precision parameter.
        train_params.precision = getattr(tf, naive_transformer_params._precision)\
            if hasattr(tf, naive_transformer_params._precision) else tf.float32
        # Whether use graph mode or eager mode.
        train_params.use_graph_mode = True
        # The ratio of train dataset. The rest is test dataset.
        train_params.train_ratio = 0.8
        # Size of buffer used in shuffle.
        train_params.buffer_size = int(1e4)
        ## -- Dataset-specific parameters
        # Normal parameters related to eeg_anonymous dataset.
        if train_params.dataset == "eeg_anonymous":
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 256
            # The learning rate of training process.
            train_params.lr = 3e-4
        # Normal parameters related to meg_anonymous dataset.
        elif train_params.dataset == "meg_anonymous":
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 128
            # The learning rate of training process.
            train_params.lr = 3e-4
        # Normal parameters related to seeg_he2023xuanwu dataset.
        elif train_params.dataset == "seeg_he2023xuanwu":
            # Number of epochs used in training process.
            train_params.n_epochs = 200
            # Number of batch size used in training process.
            train_params.batch_size = 128
            # The learning rate of training process.
            train_params.lr = 3e-4
        # Normal parameters related to other dataset.
        else:
            # Number of epochs used in training process.
            train_params.n_epochs = 20
            # Number of batch size used in training process.
            train_params.batch_size = 16
            # The learning rate of training process.
            train_params.lr = 3e-4

        # Return the final `train_params`.
        return train_params

if __name__ == "__main__":
    # Instantiate `naive_transformer_params`.
    naive_transformer_params_inst = naive_transformer_params(n_channels=273)

