#!/bin/bash
#SBATCH --job-name=naive_cnn
#SBATCH -p q_ai8
#SBATCH -n 1
#SBATCH -N 1
#SBATCH -c 1
#SBATCH --gres=gpu:1
#SBATCH --mem=128G
#SBATCH -t 48:00:00
#SBATCH -o ./slurm/slurm.%j.out
#SBATCH -e ./slurm/slurm.%j.err
# Record current host & date.
hostname; date
# Initialize conda envrionment.
source ~/.bashrc
conda activate eeg2label
# Initialize cuda environement.
module load cuda/11.2
export TF_XLA_FLAGS=--tf_xla_enable_xla_devices
export XLA_FLAGS=--xla_gpu_cuda_data_dir=/usr/nzx-cluster/apps/cuda/11.2
# Train model.
cd ./train && python naive_cnn.py

