# BiocManager::install("pkimes/sigclust2") # used for all SigClust-based methods

suppressPackageStartupMessages(library("sigclust2"))
library(filelock)
library(scSHC)
source("00_DGM.R")

P_SHC <- rep(NA, opt$nsim)
file_name <- paste0("./result/", opt$data, "_output.csv")

for (i in seq(opt$nsim)){
  # Data Generation
  generator <- generator_list[[opt$data]]
  X <- generator(n=opt$n, d=opt$d, a=opt$a, seed=2024*i)
  filter <- apply(X, 2, sd) > 0
  X <- X[, filter]
  
  rownames(X) <- paste0("cell", 1:nrow(X))
  colnames(X) <- paste0("gene", 1:ncol(X))
  # Dimension Reduction
  if(opt$data == "multinom"){
    batch <- rep(1:2, each = nrow(X)/2)
  }else{
    batch <- NULL
  }
  node <- NA
  try(node <- scSHC::scSHC(data=t(X), num_features = ncol(X), batch = batch)[[2]]$name)
  try(P_SHC[i] <- as.numeric(sub(".*: (.*)", "\\1", node)))
}

result <- data.frame(
  Distribution = opt$data,
  n = opt$n,
  d = opt$d,
  a = opt$a,
  Method = "scSHC",
  pval = P_SHC
)

lock_name <- paste0(file_name, ".lock")
lock <- lock(lock_name)
if (file.exists(file_name)) {
  current <- read.csv(file_name)
  result <- rbind(current, result)
}
write.csv(result, file=file_name, row.names = FALSE)

