# BiocManager::install("pkimes/sigclust2") # used for all SigClust-based methods

suppressPackageStartupMessages(library("sigclust2"))
library(filelock)
source("SigClust-MDS.R")
source("99_SigClust_GLM.R")
source("99_Dimension_Reduction.R")
source("00_DGM.R")

P_RIFT <- rep(NA, opt$nsim)
P_MRIFT <- rep(NA, opt$nsim)
file_name <- paste0("./result/", opt$data, "_output.csv")

for (i in seq(opt$nsim)){
  # Data Generation
  generator <- generator_list[[opt$data]]
  X <- generator(n=opt$n, d=opt$d, a=opt$a, seed=2024*i)
  filter <- apply(X, 2, sd) > 0
  X <- X[, filter]
  
  # Dimension Reduction
  Y <- dev_reduce_dimension(X, min(opt$n-1, 200), family=opt$data)[[2]]
  dissimilarity_matrix <- dist(Y, method = "euclidean", diag = T, upper = T, p = 2)
  mds_matrix <- cmdscale(dissimilarity_matrix,k = 2)
  # Cluster Significance
  output <- SigClust_GLM(mds_matrix, method="rift")
  P_RIFT[i] <- output$pval
  P_MRIFT[i] <- output$pvalnorm
}

result <- data.frame(
  Distribution = opt$data,
  n = opt$n,
  d = opt$d,
  a = opt$a,
  Method = c(rep("DEV-RIFT", opt$nsim), rep("DEV-MRIFT", opt$nsim)),
  pval = c(P_RIFT, P_MRIFT)
)

lock_name <- paste0(file_name, ".lock")
lock <- lock(lock_name)
if (file.exists(file_name)) {
  current <- read.csv(file_name)
  result <- rbind(current, result)
}
write.csv(result, file=file_name, row.names = FALSE)

