# BiocManager::install("pkimes/sigclust2") # used for all SigClust-based methods

suppressPackageStartupMessages(library("sigclust2"))
library(filelock)
source("SigClust-MDS.R")
source("SigClust-MDS.R")
source("99_Dimension_Reduction.R")
source("00_DGM.R")

P_Soft<- rep(NA, opt$nsim)
P_Hard <- rep(NA, opt$nsim)
P_MDS <- rep(NA, opt$nsim)
file_name <- paste0("./result/", opt$data, "_output.csv")

for (i in seq(opt$nsim)){
  # Data Generation
  generator <- generator_list[[opt$data]]
  X <- generator(n=opt$n, d=opt$d, a=opt$a, seed=2024*i)
  filter <- apply(X, 2, sd) > 0
  X <- X[, filter]
  
  # Dimension Reduction
  dissimilarity_matrix <- dist(X, method = "euclidean", diag = T, upper = T, p = 2)
  clust <- hclust(dissimilarity_matrix)
  label <- cutree(clust, k = 2)
  
  P_Soft[i] <- sigclust(x=X, icovest=1, labels=label)$p_norm
  P_Hard[i] <- sigclust(x=X, icovest=3, labels=label)$p_norm
  
  mds_matrix <- cmdscale(dissimilarity_matrix,k = 2)
  output <- SigClust_MDS(mds_matrix, nsim = 100, label=label, method=2)
  P_MDS[i] <- output$pvalnorm
}

result <- data.frame(
  Distribution = opt$data,
  n = opt$n,
  d = opt$d,
  a = opt$a,
  Method = c(rep("SigClust-Hard", opt$nsim), rep("SigClust-Soft", opt$nsim), rep("SigClust-MDS", opt$nsim)),
  pval = c(P_Hard, P_Soft, P_MDS)
)

lock_name <- paste0(file_name, ".lock")
lock <- lock(lock_name)
if (file.exists(file_name)) {
  current <- read.csv(file_name)
  result <- rbind(current, result)
}
write.csv(result, file=file_name, row.names = FALSE)

