# 方法

本研究将基于片段（motif）的分子装配建模为一个集中式训练、分布式执行（CTDE）的多智能体强化学习问题。核心思想是以共享的大语言模型（LLM）作为去中心化策略骨干，使每个 motif 智能体在文本化的化学约束下提出连接建议，通过全局通信机制动态重建分子的二维拓扑结构；同时以集中式评论家（critic）在训练期接收全局图信息与掩码特征以评估状态价值与装配进度，并采用多智能体近端策略优化（MAPPO）实现稳定高效的策略更新。为兼顾"重建（严格还原原分子）"与"生成（在化学有效性下优化性质）"两类目标，我们引入集合行为克隆（Set-BC）以避免装配顺序歧义、潜能塑形以加速对齐目标图、以及连通性/过连约束以规范拓扑过程。下文按"表示与分割、环境建模、智能体与评论家、奖励与塑形、策略优化与训练、推断与下游应用"六个方面进行连续叙述。

## 表示与分割

我们基于改进的 BRICS 规则按 16 类化学环境进行成键断裂，将原分子分解为保留化学语义的 bricks（至少含 2 个非氢原子）与 linkers，并完整保留连接位点与允许键型等元数据。为便于 LLM 处理并重建二维拓扑信息，我们将每个 motif 与其连接关系序列化为结构化文本。单个 motif 的描述包含唯一标识、SMILES、原子与键信息、可连接位点（含位点类型、化学环境、允许键型）、以及芳香性、环结构、功能团等性质摘要；连接关系以统一模板刻画，如"`CONNECTION: motif_i[site_x] --bond_type--> motif_j[site_y]`"，这种表示直接编码了motif间的邻接关系，保留了分子图的连通性信息。

为提高分割效率并保持拓扑完整性，我们对传统BRICS进行了优化：首先建立motif-位点到目标边的映射索引，在预处理阶段即识别所有可能的连接模式，确保分割后的motif集合能够完整重构原始分子的二维拓扑；其次，对于大分子（>50个重原子），采用分层分割策略，先识别核心骨架（如芳香环系统），再递归分割外围取代基，保持局部拓扑结构的完整性。该文本表示确保价态约束、芳香性保持、环约束与位点兼容性等关键化学规则在策略条件中显式可见，并通过全局 ID 和连接关系图保证组装过程的拓扑可追踪性。

## 环境建模

我们将装配过程视为一个 Dec-POMDP，其中状态空间直接对应分子的二维拓扑演化。时刻 (t) 的全局状态由当前装配图 (G_t=(V,E_t)) 的文本摘要、未连接 motif 列表、可用位点拓扑（哪些motif可相互连接）以及（可选）在线性质估计组成，其中 (V) 表示motif节点集合，(E_t) 表示时刻 (t) 的边集（已建立的连接）；集中式评论家在训练期额外接收结构化图特征与掩码张量以感知全局拓扑。动作定义为在两个 motif 的指定位点间施加某一键型的连接 (a_t=(i,s_i,j,s_j,b))，其中 (i,j) 为motif索引，(s_i,s_j) 为连接位点，(b) 为键型，每个动作直接修改分子的二维拓扑结构，并包含显式的 `STOP` 动作以指示终止。

为降低动作分支并保持拓扑一致性，我们分层采样：先选源 motif/位点，再基于化学兼容性和拓扑约束选目标 motif/位点，最后选键型；各层均以化学与拓扑掩码在 logits 级别剔除非法选项，确保生成的连接保持二维拓扑的有效性。环境在接收动作后进行价态、芳香性与拓扑可行性校验（如避免形成不合理的小环），更新装配图的邻接矩阵与可用位点，并输出奖励与下一个拓扑状态。

**终止条件的精确定义**：在"重建"模式下，终止的必要条件为连通分量数 (\text{cc}(G_t)=1) 且 (E_t \supseteq E^\star)，其中 (\text{cc}(\cdot)) 表示图的连通分量数，(E^\star) 为目标分子的边集；充分条件为 (E_t = E^\star) 或策略选择 `STOP` 动作，同时设置超时保护（步数 (> 2 \times |E^\star|)）防止无限循环。在"生成"模式下，终止条件包括：(1) 化学完整性，即所有必需的价键饱和；(2) 拓扑完整性，形成连通的分子图；(3) 性质收敛，连续 (k) 步性质改进 (< \varepsilon)，其中 (k) 为预设窗口大小，(\varepsilon) 为收敛阈值；(4) 主动终止，策略输出 `STOP` 概率 (> 0.9)。

## 智能体与评论家

每个 motif 对应一个文本驱动的智能体，所有智能体共享同一 LLM 作为策略骨干，并以各自的 motif 描述与当前全局装配的拓扑摘要作为条件提示生成连接提议与化学理由。关键是，每个智能体不仅知道自己的局部结构，还通过全局通信感知整个分子的二维拓扑状态。

**LLM策略网络显式建模连接决策**：在分层动作采样中，LLM通过特定的提示模板生成动作分布，每一层都考虑当前的拓扑约束。第一层选择源motif时，LLM评估每个可用motif在当前拓扑中的连接潜力；第二层条件于已选motif，评估各位点的化学活性和拓扑可达性；第三层基于源的化学环境和全局拓扑评估目标的兼容性；第四层根据两端的化学环境和目标拓扑结构确定最优键型。具体实现采用LLM的最后隐层特征，通过可训练的动作头生成logits： [\pi(a|s) = \text{Softmax}(\text{MLP}(\text{LLM}*{\text{hidden}}(\text{prompt}(s))))] 其中 (\pi) 为策略函数，(a) 为动作，(s) 为状态，(\text{LLM}*{\text{hidden}}) 表示LLM的隐层表示，(\text{prompt}(s)) 为包含当前二维拓扑完整描述的提示文本。

**集中仲裁器协调拓扑构建**：仲裁器采用两阶段协调以确保拓扑一致性。阶段1进行化学和拓扑有效性筛选：并行收集所有motif智能体的提议，通过规则引擎快速筛除违反价键规则或破坏拓扑完整性的提议。阶段2进行拓扑优先级评分与选择，评分函数为： [S(a) = w_1 \cdot \text{化学稳定性}(a) + w_2 \cdot \text{拓扑进度}(a) + w_3 \cdot \text{性质改进}(a)] 其中 (S(a)) 为动作 (a) 的评分，(w_1, w_2, w_3) 为权重系数，拓扑进度明确考虑减少连通分量数、增加关键桥接连接、形成稳定环系统等对二维拓扑完整性的贡献。

**融合表示感知全局拓扑**：集中式评论家 (V_\phi(x_t)) 的融合表示通过多模态注意力机制整合拓扑信息： [x_t = \text{MultiModalFusion}([h_{\text{text}}, h_{\text{graph}}, h_{\text{mask}}, h_{\text{topo}}])] 其中 (V_\phi) 为价值函数，(\phi) 为评论家网络参数，(x_t) 为时刻 (t) 的融合表示，(h_{\text{text}}) 为LLM编码的全局状态文本表示，(h_{\text{graph}}) 为GNN编码的当前装配图的二维拓扑结构，(h_{\text{mask}}) 为基于拓扑约束的可用动作掩码，(h_{\text{topo}}) 为拓扑统计量（连通分量数、环数量、最短路径分布等）的MLP编码。

为增强对"装配进度"和"拓扑演化"的感知，我们在价值头之外附加多任务回归头，预测剩余目标边数与连通分量，形成与拓扑进度一致的价值信号。

## 奖励与塑形

奖励设计明确考虑二维拓扑的重建和优化。化学基础奖励包括化学有效性 (r_{\text{valid}})（合法为 +1，非法为 −1）、局部稳定性 (r_{\text{stable}}=-E_{\text{strain}})，其中 (E_{\text{strain}}) 为基于力场计算的应变能、功能团形成 (r_{\text{func}}=\sum_g w_g ,\mathbb{I}{\text{形成 }g})，其中 (g) 遍历所有功能团类型，(w_g) 为权重，(\mathbb{I}) 为指示函数、目标性质对齐 (r_{\text{prop}}=-|y_{\text{pred}}-y_{\text{target}}|)，其中 (y_{\text{pred}}) 和 (y_{\text{target}}) 分别为预测和目标性质值、合成可及性 (r_{\text{SA}}) 与新颖性 (r_{\text{novel}}=1-\max_{\text{ref}}\text{Tanimoto}(\text{mol},\text{ref}))，其中Tanimoto为分子相似度度量。

拓扑塑形方面，我们设计专门的奖励引导二维拓扑的正确构建：跨分量连边奖励加速形成连通图： [r_{\text{conn}}(s_t,s_{t+1})=\big(\text{cc}(G_t)-1\big)-\big(\text{cc}(G_{t+1})-1\big),] 其中 (s_t) 和 (s_{t+1}) 为相邻时刻的状态，该奖励在减少连通分量时为正。目标边推进奖励确保准确恢复目标拓扑： [r_{\text{edge}}(s_t,s_{t+1})=|E^\star\cap E_{t+1}|-|E^\star\cap E_t|,] 其中 (\cap) 表示集合交集，该奖励等于新增的正确边数。拓扑距离奖励鼓励形成与目标相似的拓扑特征： [r_{\text{topo}}(s_t,s_{t+1})=-\text{GraphEditDistance}(G_{t+1}, G^\star),] 其中GraphEditDistance衡量两个图的编辑距离。

为防止破坏拓扑结构，在重建期对超出目标边数的连接施加惩罚： [r_{\text{over}}(s_{t+1})=-\alpha\cdot \max\big(0,; |E_{t+1}|-|E^\star|\big),] 其中 (\alpha) 为惩罚系数。潜能塑形基于拓扑差异设计，潜能函数为 (\Phi(s)=-|E^\star\setminus E(s)| - \beta \cdot \text{cc}(G_s))，其中 (\setminus) 表示集合差，(\beta) 为连通性权重，塑形后的奖励为： [r'(s_t,a_t,s_{t+1})=r(s_t,a_t,s_{t+1})+\gamma \Phi(s_{t+1})-\Phi(s_t),] 其中 (\gamma) 为折扣因子。综合各项，单步总奖励为： [R=\sum_{k=1}^{6}\lambda_k, r_k ;+; \lambda_7 r_{\text{conn}}+\lambda_8 r_{\text{edge}}+\lambda_9 r_{\text{topo}},] 其中 (r_1,\dots,r_6) 依次对应 (r_{\text{valid}},r_{\text{stable}},r_{\text{func}},r_{\text{prop}},r_{\text{SA}},r_{\text{novel}})，(\lambda_k) 为各项权重。

## 策略优化与训练

我们采用 MAPPO 进行策略更新，关键是让策略学习motif间的连接规则而非记忆特定序列。训练中，Actor（策略网络）和Critic（评论家）使用不同的损失函数分别优化。

**Actor损失函数**：策略网络通过以下损失函数优化： [\mathcal{L}*{\text{actor}} = -\mathcal{L}*{\text{clip}} - \beta\mathcal{H}(\pi_\theta) + \alpha_{\text{BC}}\mathcal{L}*{\text{BC}} + \mathcal{L}*{\text{KL}} - \sum_k \lambda_k\mathbb{E}[c_k(s)]] 其中各项含义为：

- (\mathcal{L}_{\text{clip}})：PPO截断目标，优化策略以最大化期望奖励
- (\beta\mathcal{H}(\pi_\theta))：熵正则项，(\mathcal{H}) 为熵函数，(\beta) 为熵系数，保持探索
- (\alpha_{\text{BC}}\mathcal{L}*{\text{BC}})：Set-BC监督项，(\alpha*{\text{BC}}) 为权重，学习正确的装配模式
- (\mathcal{L}_{\text{KL}})：KL散度正则，约束策略相对参考策略的变化
- (\sum_k \lambda_k\mathbb{E}[c_k(s)])：约束项，(c_k(s)) 为第 (k) 个约束的违反程度，满足化学和拓扑约束

PPO 截断目标的具体形式为： [\mathcal{L}*{\text{clip}}(\theta)=\mathbb{E}*{i,t}!\left[\min!\Big(r_t^i(\theta)\hat{A}*t,; \text{clip}\big(r_t^i(\theta),1-\epsilon,1+\epsilon\big)\hat{A}\*t\Big)\right],] 其中 (r_t^i(\theta)=\pi\*\theta(a_t^i\mid o_t^i)/\pi*{\theta_{\text{old}}}(a_t^i\mid o_t^i)) 为重要性采样比，(o_t^i) 为智能体 (i) 的观测，(\hat{A}_t) 为优势估计，(\epsilon) 为截断参数。

**Critic损失函数**：评论家网络独立优化，损失函数为： [\mathcal{L}*{\text{critic}} = \mathcal{L}\*V^{\text{main}} + \sum\*{aux} w*{aux}\mathcal{L}*V^{aux}] 展开为： [\mathcal{L}*{\text{critic}} = \mathbb{E}*t[(V*\phi(x_t) - \hat{R}*t)^2] + w_1(V*{\text{edges}}(x_t) - |E^\star\setminus E_t|)^2 + w_2(V_{\text{cc}}(x_t) - \text{cc}(G_t))^2] 其中：

- ((V_\phi(x_t) - \hat{R}_t)^2)：主价值损失，(\hat{R}_t) 为蒙特卡洛回报估计
- (V_{\text{edges}}(x_t))：预测剩余目标边数的辅助头
- (V_{\text{cc}}(x_t))：预测连通分量数的辅助头
- (w_1, w_2)：辅助任务权重

优势估计采用广义优势估计（GAE）： [\hat{A}*t = \sum*{l=0}^{\infty}(\gamma\lambda)^l \delta_{t+l},] 其中 (\delta_t = r_t + \gamma(1-d_t)V_\phi(x_{t+1}) - V_\phi(x_t)) 为TD残差，(d_t) 为终止标志，(\lambda) 为GAE参数。

**Set-BC学习拓扑等价路径**：针对同一拓扑可通过多条装配序列达到的特性，Set-BC避免强制特定顺序。正确动作集合 (\mathcal{A}^\star_t) 包含所有保持拓扑正确性的动作。监督项为： [\mathcal{L}*{\text{BC}}=-\mathbb{E}\*t!\left[\log \sum\*{a\in \mathcal{A}^\star_t}\pi*\theta(a\mid s_t)\right],] 它最大化策略对整个正确集合的概率质量。KL正则项为： [\mathcal{L}*{\text{KL}}=\beta*{\text{KL}}\cdot \text{KL}(\pi_\theta\Vert \pi_{\text{ref}}),] 其中 (\pi_{\text{ref}}) 为参考策略，(\beta_{\text{KL}}) 为KL惩罚系数。

**课程化训练逐步掌握拓扑构建**：训练分四阶段，从简单拓扑约束逐步过渡到复杂优化。阶段1（前25%）严格拓扑重建：硬掩码确保只形成目标边，Set-BC权重 (\alpha_{\text{BC}} = 1.0)，重点学习基本的拓扑连接规则。阶段2（25%-50%）软约束拓扑学习：允许探索等价拓扑路径，(\alpha_{\text{BC}}) 衰减至0.1，引入拓扑进度奖励。阶段3（50%-75%）拓扑感知的性质优化：在保持拓扑约束下引入性质奖励，学习拓扑-性质关系。阶段4（最后25%）自由拓扑探索：解除硬约束，允许在化学规则内探索新的拓扑连接模式。

**计算效率优化专注拓扑关键操作**：(1) 拓扑缓存，预计算并缓存频繁的拓扑操作（如连通性检查、最短路径）；(2) 增量拓扑更新，每次连接只更新受影响的局部拓扑特征；(3) 拓扑批处理，将相似拓扑状态分组处理。

训练流程通过并行环境采样多样的拓扑构建路径，在分层动作掩码下维护拓扑一致性，Actor和Critic分别通过各自的损失函数优化，确保学到的策略能够理解和构建正确的分子拓扑。

## 推断与下游应用

在推断期，策略基于学到的拓扑构建规则进行装配，分层掩码确保每步都保持拓扑有效性。重建任务以完全恢复目标拓扑（(E=E^\star) 且 (\text{cc}(G)=1)）为成功标准；生成任务在形成连通拓扑后，可继续在拓扑约束下优化性质，通过beam search（束宽 (k=5)）探索多条拓扑路径。

为提高推理效率，我们：(1) 拓扑剪枝，基于已学习的拓扑模式提前排除不可行路径；(2) 拓扑引导采样，优先考虑能快速形成稳定拓扑的动作；(3) 拓扑检查点，保存关键拓扑状态便于回溯和分支。

为服务下游任务，系统提供三层解释：(1) 拓扑构建解释，说明每步如何改变分子的二维连通性；(2) motif连接机理，解释特定连接位点和键型选择的化学原因；(3) 拓扑-性质关系，识别对目标性质贡献最大的拓扑特征（如特定的环系统或桥接结构）。通过复用LLM编码作为分子表征，附加的性质预测头能够感知完整的二维拓扑信息，在各类下游任务中展现出色性能。

通过上述方法，系统不仅能够准确重建分子的二维拓扑结构，克服了线性表示的信息损失，更重要的是通过多智能体协作显式学习了motif的连接规则和分子的组装原理，为理解和设计功能分子提供了拓扑感知的智能工具。

