# MotifAgent: Fragment-based Molecular Assembly with Multi-Agent Reinforcement Learning

MotifAgent is a multi-agent reinforcement learning framework for fragment-based molecular design and reconstruction. The system models molecular assembly as a centralized training, distributed execution (CTDE) problem, where LLM-based agents collaborate to construct molecules by connecting molecular fragments (motifs) under chemical and topological constraints.

## Key Features

- **Fragment-based Assembly**: Uses improved BRICS fragmentation to decompose molecules into chemically meaningful motifs
- **Multi-Agent Architecture**: LLM-based actors with centralized critic for coordinated molecular construction
- **Topology-Aware Learning**: Explicit 2D topology modeling and constraints for chemically valid assembly
- **Dual Objectives**: Supports both reconstruction (exact molecular recovery) and generation (property-guided design)
- **Curriculum Learning**: Progressive training from strict reconstruction to free exploration
- **Set Behavior Cloning**: Handles assembly order ambiguity through set-based supervision

## Architecture

```
MotifAgent/
├── motifagent/
│   ├── core/              # Core molecular representation and topology
│   │   ├── representation/  # Motif and molecular graph classes
│   │   ├── segmentation/    # BRICS-based molecular fragmentation
│   │   └── topology/        # Topology analysis and metrics
│   ├── agents/            # Multi-agent components
│   │   ├── actor/          # LLM-based motif agents
│   │   ├── critic/         # Centralized critic with multimodal fusion
│   │   └── coordinator/    # Action coordination and arbitration
│   ├── environment/       # Dec-POMDP environment modeling
│   │   ├── state/          # Assembly state representation
│   │   ├── actions/        # Hierarchical action space
│   │   └── constraints/    # Chemical and topological constraints
│   ├── rewards/           # Reward system
│   │   ├── chemical/       # Chemical stability and property rewards
│   │   └── topological/    # Topology progress and connectivity rewards
│   ├── training/          # MAPPO training framework
│   │   ├── mappo/          # Multi-agent PPO implementation
│   │   ├── curriculum/     # Curriculum learning scheduler
│   │   └── optimization/   # Set-BC and constraint optimization
│   ├── inference/         # Inference interfaces
│   │   ├── reconstruction/ # Molecular reconstruction engine
│   │   └── generation/     # Molecular generation engine
│   └── utils/             # Utilities
│       ├── chemistry/      # Chemical property calculations
│       ├── graph/          # Graph analysis tools
│       └── io/             # Data loading and saving
├── train.py               # Training script
├── evaluate.py            # Evaluation script
├── run_inference.py       # Inference script
└── requirements.txt       # Dependencies
```
