# Agent Network Natural Evolution
AgentNet: A distributed task processing MAS using a Directed Acyclic Graph (DAG) of agents with dynamic routing and memory capabilities.


## Features
- Dynamic task routing through a network of specialized agents
- Agent memory with decay mechanism
- Priority-based task processing
- Similar task recognition and few-shot learning
- Ability evolution based on task processing experience
- Load balancing and task forwarding

## Installation
1. Clone the repository
2. Create a virtual environment:
```bash
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```
3. Install dependencies:
```bash
pip install -r requirements.txt
```

## Usage
Run the main application:
```bash
python run_agentnet.py
```
For the version with ability decay:
```bash
python run_agentnet.py --decay
```

## Configuration
Agents can be configured with different initial abilities and memory limits in the run_agentnet.py file.
