#!/usr/bin/env python
# -*- coding: utf-8 -*-

from typing import Dict, Any

from prompt.prompt_set import PromptSet

class BigCodeBenchPromptSet(PromptSet):
    """
    BigCodeBench prompt set for the multi-type question answering.
    """

    @staticmethod
    def get_role():
        return "You are an AI that only responds with only python code. "

    @staticmethod
    def get_constraint():
        return (
            "You will be given a function signature and its docstring by the user. "
            "Write your full implementation (restate the function signature). "
            "Use a Python code block to write your response. For example:\n```python\nprint('Hello world!')\n```"
        )

    @staticmethod
    def get_format():
        return "natural language"
    
    @staticmethod
    def get_answer_prompt(question):
        # Format the question for the AI assistant to answer
        return f"{question}"

    @staticmethod
    def get_react_prompt(question, solution, feedback):
        return f"""Here is an unsuccessful attempt for solving the folloing question:
Question:
{question}
Attempted Solution:
{solution}
Feedback:\n{feedback}
Rewrite the code based on the feedback and the following question:
{question}"""
    
    @staticmethod
    def get_query_prompt(question):
        raise NotImplementedError

    @staticmethod
    def get_file_analysis_prompt(query, file):
        raise NotImplementedError

    @staticmethod
    def get_adversarial_answer_prompt(question):
        raise NotImplementedError


    @staticmethod
    def get_combine_materials(materials: Dict[str, Any]) -> str:
        raise NotImplementedError
