import os
import pandas as pd

def parse_profiler_report(report):
    # Split the report into lines
    lines = report.strip().split(os.linesep)
    
    # Filter out separator lines
    lines = [line for line in lines if not line.startswith('-') and '|' in line]
    
    # Parse the header to determine the columns
    header = lines[0].split('|')[1:-1]
    headers = [h.strip() for h in header]
    
    # Initialize a list to store the parsed data
    data = []
    
    # Iterate over the remaining lines to parse each row
    for line in lines[1:]:  # Skip the header row
        row_data = line.split('|')[1:-1]  # Split row into columns and ignore the first and last empty strings from split
        row_data = [cell.strip() for cell in row_data]
        data.append(dict(zip(headers, row_data)))
    
    df = pd.DataFrame.from_records(data)
    return df
