from utils.model import ModelWrapper
import random 
from tqdm import tqdm

random.seed(17)



instruction = 'Please calculate the result of the given expression. You should directly return the answer.'

models = ['Llama2_13b_chat','Llama3_8b_chat',]
for model_name in models:
    model = ModelWrapper(model_name)
    match = 0
    for _ in tqdm(range(100)):
        label = 0
        question = ""
        for i in range(5):
            x = random.randint(1,9)
            label += x
            if i == 4:
                question += f'{x} = ?'
            else:
                question += f'{x} + '
        input = [{"role": "system", "content": instruction}, {"role": "user", "content": question}]
        response = model.generate(input)[0]
        if str(label) in response:
            match += 1
    print(f'model:{model_name}\tmatch:{match}')