import numpy as np
import cv2
import os
from shapely.geometry import Polygon
import json



if __name__ == '__main__':
    data = np.load('../datasets/statespoly/poly_np.npy')
    info = np.load('../datasets/statespoly/polyinfo_np.npy')
    
    precise = 256

    all = []
    maxlen = 0
    for id in range(len(data)):
        if id % 1000 == 0:
            print(id)
        datapoly = data[id, :int(info[id, 0])]
        datapolysort = datapoly[np.argsort(datapoly[:, 0, 0])]
        infosort = info[id, 1:int(info[id, 0])+1][np.argsort(datapoly[:, 0, 0])]
        seq = [np.array([256])]
        for i in range(len(infosort)):
            tem = datapolysort[i, :int(infosort[i])]
            tem = tem//(500/precise)
            assert (tem<=255).all()
            for j, t in enumerate(tem):
                if j == 0:
                    seq.append(t)
                elif not (t == tem[j-1]).all():
                    seq.append(t)
            
            seq.append(np.array([257]))
        seq.append(np.array([258]))
        scene = np.concatenate(seq, axis = 0)
        if len(scene)>maxlen:
            maxlen = len(scene)
        all.append(scene)

    print(maxlen)

    datas = np.ones([len(data), maxlen])*259

    for i, k in enumerate(all):
        datas[i, :len(k)] = k

    print(datas.shape)

    np.save('./polydiscre256.npy', datas)

    visdata = np.load('./polydiscre256.npy')

    for i in range(10):
        print(i)
        seq = visdata[i]
        step = 0
        gen_poly = []
        
        while True:
            assert seq[step] != 259
            if seq[step] == 256:
                pts = []
                step +=1
            elif seq[step] == 257:
                gen_poly.append(pts)
                pts = []
                step +=1
            elif seq[step] == 258:
                break
            else:
                pts.append([seq[step], seq[step+1]])
                step+=2

        img = np.ones((256,256,3),np.uint8)*255
        for pts in gen_poly:
            pts = np.array(pts, np.int32)
            pts = pts.reshape((-1,1,2)).astype(int)

            cv2.fillPoly(img, [pts], color=(255, 255, 0))

        for pts in gen_poly:
            pts = np.array(pts, np.int32)
            pts = pts.reshape((-1,1,2)).astype(int)

            cv2.polylines(img,[pts],True,(0,0,0),1)

        cv2.imwrite(f'./img/{i}.jpg',img)


