import numpy as np
import cv2
import os
from shapely.geometry import Polygon
import json



if __name__ == '__main__':
    data = np.load('../datasets/data1000/poly_np.npy')
    datainfo = np.load('../datasets/data1000/polyinfo_np.npy')
    savedir = '../results/test/gt_image_1000/'

    if not os.path.exists(savedir+'img/'):
        os.makedirs(savedir+'img/')

    list_count=[]
    list_ratio=[]
    list_area=[]
    list_edge=[]

    for i in range(1000):
        if i%100 == 0:
            print(i)
        scene = data[i]
        info = datainfo[i]

        total_area=0
        list_count.append(int(info[0]))

        img = np.ones((1000,1000,3),np.uint8)*255
        for k in range(int(info[0])):  
            poly = scene[k, :int(info[k+1]), :]
            pts = np.array(poly, np.int32)
            pts = pts.reshape((-1,1,2)).astype(int)

            list_edge.append(int(info[k+1]))

            areatem = Polygon(poly).area
            list_area.append(areatem)
            total_area+= areatem

            cv2.fillPoly(img, [pts], color=(255, 255, 0))
            cv2.polylines(img,[pts],True,(0,0,0),1)

        list_ratio.append(total_area/1000**2)

        cv2.imwrite(f'{savedir}img/{i}.jpg',img)

    dict_100 = {'count': list_count,
                'area': list_area,
                'edge': list_edge,
                "ratio":list_ratio}

    with open(f'{savedir}'+'wd.json', 'w') as json_file:
        json.dump(dict_100, json_file)