import argparse
import numpy as np
import os
import sys
sys.path.append('../share')
sys.path.append('../model')

import torch
import torch.backends.cudnn as cudnn
from models_mage import MAGECityPolyGen
from models_pospred import MAGECityPosition
from dataloader import PolyDataset2D
from function import pad_poly, in_poly_idx

import cv2
from shapely.geometry import Polygon


def infgen(model, modelpos, samples, sample_inter, pos, device, x, y, discard_prob = 0.5, discre = 100, max_build = 250, use_sample=False, finetune = False):

    inlen = samples.shape[1]  
    print(inlen)
    samples_iter = samples.clone()
    pos_iter = pos.clone()

    remain_flag = torch.ones([discre,discre]).to(device)
    if x!=0:
        remain_flag[:discre//2, :] = 0
    if y!=0:
        remain_flag[:, :discre//2] = 0
    remain_flag = remain_flag.flatten(0,1)
    for p in pos[0]:
        remain_flag[int(p[0]*discre+p[1])] = 0
        

    endflag = 0
    gen_iter = []

    num_poly = inlen
    
    for _ in range(max_build - inlen):
        pred = modelpos(samples_iter, pos_iter, None, generate = True)
        prob_pred = torch.sigmoid(pred[0, :])
        prob_pred = torch.where(prob_pred < discard_prob, torch.tensor(0.0).to(device), prob_pred) 
        while True:
            prob_pred = prob_pred*remain_flag
            if torch.max(prob_pred) < discard_prob:
                endflag = 1
                break      
            if use_sample == False:
                idx_iter = torch.argmax(prob_pred)
            else:            
                idx_iter = torch.multinomial(prob_pred, 1).squeeze(0)
                                
            remain_flag[idx_iter] = 0

            pred_pos = torch.cat([idx_iter.unsqueeze(0)//discre, idx_iter.unsqueeze(0)%discre],dim=0).unsqueeze(0).unsqueeze(0)
            predpoly = model.infgen(samples_iter, pos_iter, pred_pos)[0]

            polygon = Polygon(np.array(predpoly[0].clone().detach().cpu()))
            intersect_flag = 0
            for pe in range(samples_iter.shape[1]):
                polyexist = [] 
                for k in range(samples_iter.shape[2]):
                    if samples_iter[0, pe, k, 0] != 0:
                        point = samples_iter[0, pe, k, :].clone().detach().cpu().numpy()
                        polyexist.append(point)
                polyexist = Polygon(polyexist)
                if polygon.intersects(polyexist):
                    intersect_flag = 1
                    break

            for polyexist in sample_inter:
                polyexist = Polygon(polyexist.cpu().numpy())
                if polygon.intersects(polyexist):
                    intersect_flag = 1
                    break

            if intersect_flag == 0:
                break

        if endflag == 1:
            break

        poly_add, pos_add = pad_poly(predpoly)
        poly_add = poly_add.to(device)
        pos_add = pos_add.to(device)
        samples_iter = torch.cat([samples_iter, poly_add], dim = 1).detach()
        pos_iter = torch.cat([pos_iter, pos_add], dim = 1).detach()
        num_poly+=1

        gen_iter.append(predpoly.squeeze(0).detach())
        remain_flag = remain_flag*in_poly_idx(predpoly.squeeze(0).detach().cpu(), discre=discre).to(device)

    if finetune:
        gen_iter = model.infgen(samples, pos, pos_iter[:, inlen:])
        gen_iter = [genpoly.squeeze(0).detach() for genpoly in gen_iter]

    return gen_iter


def get_args_parser():
    parser = argparse.ArgumentParser('MAE pre-training', add_help=False)
    parser.add_argument('--batch_size', default=1, type=int,
                        help='Batch size per GPU (effective batch size is batch_size * accum_iter * # gpus')
    parser.add_argument('--epochs', default=1, type=int)

    parser.add_argument('--device', default='cuda',
                        help='device to use for training / testing')
    parser.add_argument('--seed', default=0, type=int)

    parser.add_argument('--num_workers', default=20, type=int)
    parser.add_argument('--pin_mem', action='store_true',
                        help='Pin CPU memory in DataLoader for more efficient (sometimes) transfer to GPU.')
    parser.add_argument('--no_pin_mem', action='store_false', dest='pin_mem')
    
    parser.add_argument('--stage1_model_path', type = str, default='../results/model/stage1_2d_1000meter.pth')
    parser.add_argument('--stage2_model_path', type = str, default='../results/model/stage2_2d_1000meter.pth')
    parser.add_argument('--save_path', type = str, default="../results/test/states_poly_infinite/")
    parser.add_argument('--data_path', type=str, default='../datasets/statespoly')
    parser.add_argument('--translation', type = float, default=0.5)
    
    parser.set_defaults(pin_mem=True)

    return parser

def main(args):
    device = torch.device(args.device)

    seed = args.seed
    torch.manual_seed(seed)
    np.random.seed(seed)

    cudnn.benchmark = True

    dataset_test = PolyDataset2D(args.data_path, train=False, split_ratio = 0.9)


    data_loader_test = torch.utils.data.DataLoader(
        dataset_test, 
        batch_size=args.batch_size,
        num_workers=args.num_workers,
        pin_memory=args.pin_mem,
        drop_last=True,
    )
    

    modelpos = MAGECityPosition(embed_dim=512, depth=6, num_heads=8, 
                                 decoder_embed_dim=16, decoder_depth=3,   
                                 decoder_num_heads=8, discre = 100, patch_size = 10, patch_num = 10, 
                                 device = device, ablation = False, patchify = True)
    
    pretrained_modelpos = torch.load(args.stage1_model_path)
    modelpos.load_state_dict(pretrained_modelpos, strict = False)
    modelpos.to(device)
    modelpos.eval()
    
    model = MAGECityPolyGen(num_heads=8, device=device,
                        depth=12, embed_dim=512, decoder_embed_dim=512,
                        decoder_depth=8, decoder_num_heads=8,
                        max_build=250, max_poly=20, discre=100)
    
    pretrained_model = torch.load(args.stage2_model_path)
    model.load_state_dict(pretrained_model)
    model.to(device)
    model.eval()

    image_num = 0
    size = 1000

    assert args.batch_size == 1
    inf_t = args.translation*size
    inf_num = 3

    for data_iter_step, (ini_samples, _, ini_info) in enumerate(data_loader_test):
        if data_iter_step >= 50:
           break

        for t in range(10):
            samples_draw = []

            for i in range(int(ini_info[0,0])):
                samples_draw.append(ini_samples[0, i, :int(ini_info[0,i+1])])
            
            
            for j in range(inf_num+1):
                for i in range(inf_num+1):   

                    sample_in = []
                    sample_inter = []
                    for poly in samples_draw:
                        if ((i*inf_t<poly[:, 0])*(poly[:, 0]<(i*inf_t + size))*(j*inf_t<poly[:, 1])*(poly[:, 1]<(j*inf_t + size))).all():
                            poly_ = poly.clone()
                            poly_[:, 0] -= i*inf_t
                            poly_[:, 1] -= j*inf_t
                            sample_in.append(poly_)
                    
                    for poly in samples_draw:
                        if ((i*inf_t<poly[:, 0])*(poly[:, 0]<(i*inf_t + size))*(j*inf_t<poly[:, 1])*(poly[:, 1]<(j*inf_t + size))).any():
                            poly_ = poly.clone()
                            poly_[:, 0] -= i*inf_t
                            poly_[:, 1] -= j*inf_t
                            sample_inter.append(poly_)

                    sample_in, pos_in = pad_poly(sample_in)
                    if sample_in.shape[1]>=250:
                        continue
                    sample_in = sample_in.to(device)
                    pos_in = pos_in.to(device)
                    if t == 0:
                        gen_poly = infgen(model = model, modelpos = modelpos, samples = sample_in, sample_inter = sample_inter, pos = pos_in, device = device, x=i, y=j, use_sample=False)
                    else:
                        gen_poly = infgen(model = model, modelpos = modelpos, samples = sample_in, sample_inter = sample_inter, pos = pos_in, device = device, x=i, y=j, use_sample=True)
                    for polybulid in gen_poly:
                        polydraw = polybulid.clone()
                        polydraw[:, 0] += i*inf_t
                        polydraw[:, 1] += j*inf_t
                        samples_draw.append(polydraw)
                      
            img = np.ones((int(size+inf_num*inf_t),int(size+inf_num*inf_t),3),np.uint8)*255

            for num, poly in enumerate(samples_draw):
                pts = np.array(poly.cpu(), np.int32)
                pts = pts.reshape((-1,1,2)).astype(int)
                if num < int(ini_info[0,0]):
                    cv2.fillPoly(img, [pts], color=(238, 159, 153))
                    cv2.polylines(img,[pts],True,(0,0,0),1)
                else:
                    cv2.fillPoly(img, [pts], color=(255, 255, 0))
                    cv2.polylines(img,[pts],True,(0,0,0),1)
            
            dir_path = args.save_path
            if not os.path.exists(dir_path):
                    os.makedirs(dir_path)
            image_num += 1
            print(image_num)
                    
            cv2.imwrite(f'{dir_path}'+str(data_iter_step)+'_'+str(t) +'.jpg',img)





if __name__ == '__main__':
    args = get_args_parser()
    args = args.parse_args()
    main(args)

