import argparse
import numpy as np
import os
import sys
sys.path.append('../share')
sys.path.append('../model')

import torch
import torch.backends.cudnn as cudnn
from models_mage import MAGECityPolyGenSample
from models_pospred import MAGECityPosition
from dataloader import PolyDataset2D
from function import pad_poly, in_poly_idx

import cv2
from shapely.geometry import Polygon


def infgen(model, modelpos, device, discard_prob = 0.5, use_sample=False, finetune = False):

    remain_flag = torch.ones(2500).to(device)
        
    endflag = 0
    gen_iter = []

    num_poly = 0
    
    for npoly in range(60):
        if npoly == 0:     
            x, y = torch.rand([1])*50, torch.rand([1])*50
            print(x, y)
            pred_pos = torch.cat([x, y],dim=0).unsqueeze(0).unsqueeze(0)
            
            predpoly = model.genfirst(pred_pos)[0]
            
            poly_add, pos_add = pad_poly(predpoly)
            poly_add = poly_add.to(device)
            pos_add = pos_add.to(device)
            samples_iter = poly_add.detach()
            pos_iter = pos_add.detach()
            num_poly+=1

            gen_iter.append(predpoly.squeeze(0).detach())
            remain_flag = remain_flag*in_poly_idx(predpoly.squeeze(0).detach().cpu()).to(device)
        else:
            pred = modelpos(samples_iter, pos_iter, None, generate = True)
            prob_pred = torch.sigmoid(pred[0, :])
            prob_pred = torch.where(prob_pred < 0.5, torch.tensor(0.0).to(device), prob_pred) 
            while True:
                prob_pred = prob_pred*remain_flag
                if torch.max(prob_pred) < discard_prob:
                    endflag = 1
                    break      
                if use_sample == False:
                    idx_iter = torch.argmax(prob_pred)
                else:            
                    idx_iter = torch.multinomial(prob_pred, 1).squeeze(0)
                                    
                remain_flag[idx_iter] = 0

                pred_pos = torch.cat([idx_iter.unsqueeze(0)//50, idx_iter.unsqueeze(0)%50],dim=0).unsqueeze(0).unsqueeze(0)
                predpoly = model.infgen(samples_iter, pos_iter, pred_pos)[0]

                polygon = Polygon(np.array(predpoly[0].clone().detach().cpu()))
                intersect_flag = 0
                for pe in range(samples_iter.shape[1]):
                    polyexist = [] 
                    for k in range(samples_iter.shape[2]):
                        if samples_iter[0, pe, k, 0] != 0:
                            point = samples_iter[0, pe, k, :].clone().detach().cpu().numpy()
                            polyexist.append(point)
                    # print(polygon, polyexist)
                    polyexist = Polygon(polyexist)
                    polygon = polygon.buffer(0)
                    polyexist = polyexist.buffer(0)
                    if polygon.intersection(polyexist).area>10:
                        intersect_flag = 1
                        break

                if intersect_flag == 0:
                    break

            if endflag == 1:
                break
            
            poly_add, pos_add = pad_poly(predpoly)
            poly_add = poly_add.to(device)
            pos_add = pos_add.to(device)
            samples_iter = torch.cat([samples_iter, poly_add], dim = 1).detach()
            pos_iter = torch.cat([pos_iter, pos_add], dim = 1).detach()
            num_poly+=1

            gen_iter.append(predpoly.squeeze(0).detach())
            remain_flag = remain_flag*in_poly_idx(predpoly.squeeze(0).detach().cpu()).to(device)

    if finetune:
        gen_iter = model.genfirst(pos_iter)
        gen_iter = [genpoly.squeeze(0).detach() for genpoly in gen_iter]
 
    print("gen:", len(gen_iter))
    return gen_iter

def pad_poly(poly_list, max_l = 20):
    num = len(poly_list)
    
    pad_poly = torch.zeros([num, 20, 2])
    pos_in = torch.zeros([num, 2])
    for i in range(num):
        pad_poly[i, :poly_list[i].shape[0], :] = poly_list[i]
        pos_in[i,:] = torch.mean(poly_list[i], dim = 0)//10
    
    return pad_poly.unsqueeze(0), pos_in.unsqueeze(0)
    
   
def get_args_parser():
    parser = argparse.ArgumentParser('MAE pre-training', add_help=False)
    parser.add_argument('--batch_size', default=1, type=int,
                        help='Batch size per GPU (effective batch size is batch_size * accum_iter * # gpus')
    parser.add_argument('--epochs', default=1, type=int)

    parser.add_argument('--device', default='cuda',
                        help='device to use for training / testing')
    parser.add_argument('--seed', default=0, type=int)

    parser.add_argument('--num_workers', default=20, type=int)
    parser.add_argument('--pin_mem', action='store_true',
                        help='Pin CPU memory in DataLoader for more efficient (sometimes) transfer to GPU.')
    parser.add_argument('--no_pin_mem', action='store_false', dest='pin_mem')
    
    parser.add_argument('--stage2_model_path', type = str, default='../results/model/stage2_2d_sample.pth')
    parser.add_argument('--data_path', type=str, default='../datasets/statespoly')
    parser.add_argument('--save_path', type = str, default="../results/test/states_poly_gen_2d_sample_sampos/")
    
    parser.set_defaults(pin_mem=True)
    return parser


def main(args):
    device = torch.device(args.device)

    seed = args.seed
    torch.manual_seed(seed)
    np.random.seed(seed)

    cudnn.benchmark = True
    dir_path = args.save_path
    if not os.path.exists(dir_path):
        os.makedirs(dir_path)
        
    dataset_test = PolyDataset2D(args.data_path, train=False, split_ratio = 0.8)

    data_loader_test = torch.utils.data.DataLoader(
        dataset_test, 
        batch_size=args.batch_size,
        num_workers=args.num_workers,
        pin_memory=args.pin_mem,
        drop_last=True,
    )
    
    model = MAGECityPolyGenSample(num_heads=8, device=device,
                        depth=12, embed_dim=512, decoder_embed_dim=512,
                        decoder_depth=8, decoder_num_heads=8, quant = 250,
                        max_build=60, max_poly=20, discre=50)
    
    pretrained_model = torch.load(args.stage2_model_path)
    model.load_state_dict(pretrained_model)
    model.to(device)
    model.eval()

    image_num = 0

    for valid_step, (samples, pos, info) in enumerate(data_loader_test):
        if valid_step >100:
            break

        assert pos.shape[0] == 1
        img = np.ones((500,500,3),np.uint8)*255

        for num, pts in enumerate(pos[0, :int(info[0,0])]):
            pts = np.array(pts, np.int32)*10
            cv2.circle(img,pts, 2, (0, 0, 0), 4)

        cv2.imwrite(f'{dir_path}'+str(image_num)+'_pos.jpg',img)

        pos = pos[:, :int(info[0,0]), :].to(device)
        for i in range(10):
            gen_poly = model.infgen(torch.zeros([1, 0, 20, 2]).to(device), torch.zeros([1, 0, 2]).to(device), pos, random_ = True)

            img = np.ones((500,500,3),np.uint8)*255

            for num, poly in enumerate(gen_poly):
                
                pts = np.array(poly.cpu(), np.int32)
                pts = pts.reshape((-1,1,2)).astype(int)
                cv2.fillPoly(img, [pts], color=(255, 255, 0))

            for num, poly in enumerate(gen_poly):
                pts = np.array(poly.cpu(), np.int32)
                pts = pts.reshape((-1,1,2)).astype(int)
                cv2.polylines(img,[pts],True,(0,0,0),1)           
                    
            cv2.imwrite(f'{dir_path}'+str(image_num)+f'_{i}' +'.jpg',img)
        image_num += 1
        print(image_num)
    

if __name__ == '__main__':
    args = get_args_parser()
    args = args.parse_args()
    main(args)

