#!/bin/bash

# Support model: UltraCM-13B, Auto-J-13B
# promethus_path=/cpfs01/user/lantian/kaist-ai/prometheus-13b-v1.0
ultracm_13b_path=/cpfs01/user/lantian/openbmb/UltraCM-13b
autoj_13b_path=/cpfs01/user/lantian/GAIR/autoj-13b
internlm2_20b_path=/cpfs01/shared/public/public_hdd/llmeval/model_weights/hf_hub/models--internlm--internlm2-chat-20b/snapshots/3f710f76f56f8c40dc5dd800dbe66f3341cb2c87
llama2_13b_chat_path=/cpfs01/shared/public/public_hdd/llmeval/model_weights/hf_hub/models--meta-llama--Llama-2-13b-chat-hf/snapshots/c2f3ec81aac798ae26dcc57799a994dfbf521496

# exist critic file
tigerscore_existed_crit_file=output/TIGERScore-13B/critique/result_04_17_00_13_39.jsonl
ultracm_existed_crit_file=output/UltraCM-13b/critique/result_04_17_15_01_00.jsonl
autoj_existed_crit_file=output/autoj-13b/critique/result_04_16_23_10_28.jsonl

tigerscore_existed_corr_file=output/correction/TIGERScore-13B/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_17_13_49_58.jsonl
ultracm_existed_corr_file=output/correction/UltraCM-13b/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_17_15_18_16.jsonl
autoj_existed_corr_file=output/correction/autoj-13b/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_17_14_09_10.jsonl

internlm2_7b_chat_nips2024_v1_path=output/84_hf_ckpt/critique/result_04_25_04_59_46.jsonl
internlm2_7b_chat_nips2024_v2_path=output/85_hf_ckpt/critique/result_04_25_00_27_58.jsonl
internlm2_7b_chat_nips2024_v3_path=output/85_hf_ckpt/critique/result_04_25_02_45_26.jsonl
internlm2_7b_chat_nips2024_v4_path=output/234_hf_ckpt/critique/result_04_25_07_17_44.jsonl
internlm2_7b_chat_autoj_path=output/48_hf_ckpt/critique/result_04_25_13_51_28.jsonl
internlm2_7b_chat_ultracm_path=output/2160_hf_ckpt/critique/result_04_25_13_15_03.jsonl


#########################

# internlm2_7b_chat_nips2024_v1_correction_path=output/correction/84_hf_ckpt/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_25_18_53_51.jsonl
internlm2_7b_chat_nips2024_v1_correction_path=output/correction/84_hf_ckpt/3f710f76f56f8c40dc5dd800dbe66f3341cb2c87/correction/zs-cot_result_04_27_00_19_24.jsonl
internlm2_7b_chat_nips2024_v2_correction_path=output/correction/85_hf_ckpt/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_26_03_26_22.jsonl
internlm2_7b_chat_nips2024_v3_correction_path=output/correction/85_hf_ckpt/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_26_05_11_50.jsonl
internlm2_7b_chat_nips2024_v4_correction_path=output/correction/234_hf_ckpt/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_26_06_59_30.jsonl

internlm2_7b_chat_autoj_correction_path=output/correction/48_hf_ckpt/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_25_15_55_12.jsonl
internlm2_7b_chat_ultracm_correction_path=output/correction/2160_hf_ckpt/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_25_15_32_10.jsonl

internlm2_7b_chat_path=output/aliyun_Ampere_v1_1_FT_v1_0_0_s1_rc48_1660_hf_ckpt/critique/zs-crit-cot_result_04_25_16_55_00.jsonl
# internlm2_7b_chat_correction_path=output/correction/aliyun_Ampere_v1_1_FT_v1_0_0_s1_rc48_1660_hf_ckpt/c2f3ec81aac798ae26dcc57799a994dfbf521496/correction/zs-cot_result_04_25_17_20_32.jsonl
internlm2_7b_chat_correction_path=output/correction/aliyun_Ampere_v1_1_FT_v1_0_0_s1_rc48_1660_hf_ckpt/3f710f76f56f8c40dc5dd800dbe66f3341cb2c87/correction/zs-cot_result_04_25_20_40_36.jsonl


# Correction with llama2-13b-chat model as the base; prompt_type: fs, zs-crit-cot, zs-crit-ao-1
## 提前准备好existed_crit_file作为输入
echo "==========================================================="
echo $existed_crit_file
echo "Critic Model for Correction: $critic_model_name"
echo "==========================================================="

CUDA_VISIBLE_DEVICES=0 python evaluate.py  \
    --available_gpus 0 \
    --tasks C \
    --hf_model $internlm2_20b_path \
    --prompt_type zs-crit-cot \
    --enable_code_execution \
    --existed_corr_file output_correction_add_critic/Themis/530_hf_ckpt/correction/zs-cot_result_07_18_14_20_33.jsonl
echo "==========================================================="
