#!/bin/bash

models=(sft_hf_rm_v7_relabel_rm_reverse_0_1_relabel_add_mathcode_0_2_mathcode_no_reference_128 sft_hf_rm_v7_relabel_rm_reverse_0_1_relabel_add_mathcode_0_4_mathcode_no_reference_256 sft_hf_rm_v7_relabel_rm_reverse_0_1_relabel_add_mathcode_0_6_mathcode_no_reference_160)

for index in $(seq 0 2)
do
    model=/cpfs02/llm/shared/public/lantian/exp/transfer_from_tos/${models[$index]}
    #model=${models[$index]}
    index=$(($index+0))

    if [[ $model == *"no_ref"* ]]; then
        # inference donot contain reference prompt
        reference=False
    else
        reference=True
    fi
    reference=True

    if [[ $model == *"no_criteria"* ]]; then
        # inference donot contain criteria prompt
        criteria=False
    else
        criteria=True
    fi

    if [[ $model == *"no_task"* ]]; then
        # inference donot contain task prompt
        task=False
    else
        task=True
    fi


    if [[ $model == *"no_all"* ]]; then
        # inference donot contain task prompt
        task=False
        criteria=False
        reference=False
    fi
    echo "Inference $model on GPU[$index] | task [$task] | criteria [$criteria] | reference [$reference]"
    CUDA_VISIBLE_DEVICES=$index python feedback_models.py --model_name $model --output_dir 20240823_rlhf_singleturn_temp_07_add_system_prompt --reference $reference --task $task --criteria $criteria --split dev &
done
