task_and_criteria_markdown_template = """
// a string for task description
# Task Description
A string analyze the attribute of the task

# Two-tier Structure of Criteria
// a block for one primary criteria consisting of no more than 3 fine-grained criteria. Keep output following struture in order. Variable in `{{}}` should be replaced.
## {{Name of First Primary Criteria}}
// a string of the description and details of this first-tier primary criteria
Description: {{description}}

### {{Name of Fine-grained Criteria}}
// a string of the description and details of this second-tier 
fine-grained criteria
Description: {{description}}
// a word reflects the significance of fine-grained criteria, select degree from three types (least to most significance): (1) normal; (2) medium; (3) important
Degree: {{degree}}

// lines for other fine-grained criteria which have the same structure above
...

// blocks for second primary criteria which have the same structure above
## {{Name of Second Primary Criteria}}
...
"""

summarize_feedback_markdown_template = """
// After carefully analyzing all the feedbacks provided by other models, a list of ground-truth flaws located in the response are generated as follows. Replace `{{}}` with your generations.
# Ground-Truth Feedback

## Feedback Entry 1
// Mark the location of the sentences that contain flaws with their corresponding citation symbols (like [S1] and [S2]). If the error spans multiple sentences, please output their related multiple citation symbols sequentially, like "[S1] [S2] [S3]".
Citation Symbol: {{citation_symbol}}
// a string describes the flaws
Description: {{description}}
// a string reflects the only one criteria for this flaw
Belong to Criteria: {{criteria_name}}
// a string reflects the severity of this flaw. Rank the severity of flaws from four types (least to most severe): (1) Negligible; (2) Minor; (3) Moderate; (4) Severe. 
Severity: {{severity}}
// a revision suggestion for this flaw
Suggestion: {{suggestion}}

// lines for other feedbacks which have the same structure above
## Feedback Entry 2
...
    
// the summarization of the response performance on all criteria
# Summarize
       
// a description of response performance in the **first-tier primary criteria**, replace `{{}}` with the specific criteria and the corresponding description of response performance.
{{primary_criteria_name}}: {{description}}
// lines for other criteria which have the same structure above
...
        
# Final Judgement
// a score selected from 1 to 10. where higher scores denotes better quality and lower scores denotes worse quality. Replace `{{}}` with your generated score. **Directly generate the final score, without any explanation.**
Score: {{score}}
"""

meta_critique_markdown_template = """
// a list of analysis about the feedback entries generated by {{model_name}} and their error category. Replace the variable `{{}}` with their value.
[START] Analysis of Feedbacks Generated by {{model_name_1}} [START]
            
## Feedback Entry 1
// a string describe the error in the first feedback entry for the response
Description: {{description}}
// a string reflect the error type described above, selected from E0, E1, E2, E3, E4, E5, E6. If there are multiple errors in this feedback entry, please list them with comma as separator. Notice that E0 means the feedback entry analyze the errors in response accurately, without any problem.
Error Type: {{error_type}}
// Should and why should the information of this feedback entry be included in your final list of feedback analysis? Firstly generate the reasons and then select decision from Yes or No (in format `Decision: Yes/No.`). Note that some valuable feedback entries that contain errors may still be considered for inclusion in the final feedback entry list after necessary revision, therefore feedback entries with errors may still have a "Yes" decision.
Consideration: {{decision_and_reason}}

// lines for the analysis of other feedbacks generated by {{model_name_1}} which have the same structure above
## Feedback Entry 2
...

[END] Analysis of Feedbacks Generated by {{model_name_1}} [END]

// a block contains feedback entries generated by {{model_name_2}}
[START] Analysis of Feedbacks Generated by {{model_name_2}} [START]
...
[END] Analysis of Feedbacks Generated by {{model_name_2}} [END]

...
"""

feedback_markdown_template = """
// a list of flaws located in the response, keep output following struture in order. Replace `{{}}` with your generations.
# List of Flaws in Response

## Feedback Entry 1
// Mark the location of the sentences that contain flaws with their corresponding citation symbols (like [S1] and [S2]). If the error spans multiple sentences, please output their related multiple citation symbols sequentially, like "[S1] [S2] [S3]".
Citation Symbol: {{citation_symbol}}
// a string describes the flaws
Description: {{description}}
// a string reflects the criteria for this flaw, which should be selected from the criteria defined above. Note that only one criteria is allowed for each feedback entry. Do NOT add multiple criteria in one feedback entry.
Belong to Criteria: {{criteria_name}}
// a string reflects the severity of this flaw. Select the severity of flaws from four types (least to most severe): (1) Negligible; (2) Minor; (3) Moderate; (4) Severe. 
Severity: {{severity}}
// a revision suggestion for this flaw
Suggestion: {{suggestion}}

// lines for other feedbacks which have the same structure above
## Feedback Entry 2
...
"""
