#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Python version: 3.6

import argparse


def args_parser():
    parser = argparse.ArgumentParser()

    # federated arguments (Notation for the arguments followed from paper)
    parser.add_argument('--epochs', type=int, default=10,
                        help="number of rounds of training")
    parser.add_argument('--num_users', type=int, default=100,
                        help="number of users: K")
    parser.add_argument('--frac', type=float, default=0.1,
                        help='the fraction of clients: C')
    parser.add_argument('--local_ep', type=int, default=10,
                        help="the number of local epochs: E")
    parser.add_argument('--local_bs', type=int, default=10,
                        help="local batch size: B")
    parser.add_argument('--lr', type=float, default=0.01,
                        help='learning rate')
    parser.add_argument('--momentum', type=float, default=0.5,
                        help='SGD momentum (default: 0.5)')
    parser.add_argument('--nclass', type=int, default=2,
                        help="number of image classes per client have")
    parser.add_argument('--nsamples', type=int, default=20,
                        help="number of images per class per client have")
    parser.add_argument('--rate_unbalance', type=float, default=1.0,
                        help="unbalance rate")
    parser.add_argument('--concat', type=bool, default=True,
                        help="concatenate features")


    # model arguments
    parser.add_argument('--model', type=str, default='mlp', help='model name')
    parser.add_argument('--kernel_num', type=int, default=9,
                        help='number of each kind of kernel')
    parser.add_argument('--kernel_sizes', type=str, default='3,4,5',
                        help='comma-separated kernel size to \
                        use for convolution')
    parser.add_argument('--num_channels', type=int, default=1, help="number \
                        of channels of imgs")
    parser.add_argument('--norm', type=str, default='batch_norm',
                        help="batch_norm, layer_norm, or None")
    parser.add_argument('--num_filters', type=int, default=32,
                        help="number of filters for conv nets -- 32 for \
                        mini-imagenet, 64 for omiglot.")
    parser.add_argument('--max_pool', type=str, default='True',
                        help="Whether use max pooling rather than \
                        strided convolutions")
    
    # pruning arguments
    parser.add_argument('--prune_percent', type=float, default=10,
                        help='pruning percent')
    parser.add_argument('--prune_start_acc', type=float, default=0.8,
                        help='pruning start acc')
    parser.add_argument('--prune_end_rate', type=float, default=0.5,
                        help='pruning end rate')
    parser.add_argument('--mask_ratio', type=float, default=0.5,
                        help='mask ratio')

    # sampling arguments
    parser.add_argument('--num_samples', type=int, default=100,
                        help='number of samples for HAR')

    # other arguments
    parser.add_argument('--dataset', type=str, default='mnist', help="name \
                        of dataset")
    parser.add_argument('--save_models_filename', type=str, default='../saved_models/tmp.pt', help="path \
                        of saved models")
    parser.add_argument('--num_classes', type=int, default=10, help="number \
                        of classes")
    parser.add_argument('--gpu', default=None, help="To use cuda, set \
                        to a specific GPU ID. Default set to use CPU.")
    parser.add_argument('--optimizer', type=str, default='sgd', help="type \
                        of optimizer")
    parser.add_argument('--iid', type=int, default=1,
                        help='Default set to IID. Set to 0 for non-IID.')
    parser.add_argument('--unequal', type=int, default=0,
                        help='whether to use unequal data splits for  \
                        non-i.i.d setting (use 0 for equal splits)')
    parser.add_argument('--stopping_rounds', type=int, default=10,
                        help='rounds of early stopping')
    parser.add_argument('--verbose', type=int, default=1, help='verbose')
    parser.add_argument('--seed', type=int, default=1, help='random seed')

    # VFL dropout arguments
    parser.add_argument('--dropout_rate', type=float, default=0.3, help="rate of dropout")
    parser.add_argument('--vfl_dropout', default=False, action='store_true',
                        help="conduct dropout in VFL")

    # adversarial arguments
    parser.add_argument('--l_adv', type=float, default=0.1, help="lambda of adversarial training")
    parser.add_argument('--num_mc_sample', type=int, default=40, help="number of samples for MC attack")
    parser.add_argument('--epoch_mc', type=int, default=10, help="number of training epochs for MC attack")
    parser.add_argument('--adv_model', type=str, default='large')
    parser.add_argument('--mc', type=str, default='passive')
    parser.add_argument('--lambda_TV', type=float, default=1e1, help="lambda of TV reg")
    parser.add_argument('--lambda_l2', type=float, default=0, help="lambda of l2 reg")


    # defense arguments
    parser.add_argument('--defense_method', type=str, default='None', help="define defense method (laplacian_noise, compression, ppdl, discrete_sgd)")
    parser.add_argument('--num_head_layer', type=int, default=3, help="number of head model layers")
    parser.add_argument('--MID_rate', type=float, default=0, help="strength of MID defense")
    parser.add_argument('--laplacian_noise', type=float, default=0, help="scale of laplacian noise")
    parser.add_argument('--compress', type=float, default=1, help="compression rate (proportion to keep)")
    parser.add_argument('--ppdl_theta', type=float, default=1, help="theta (proportion to keep) in privacy preserving deep learning")
    parser.add_argument('--ppdl_tau', type=float, default=0.001, help="tau (threshold) in privacy preserving deep learning")
    parser.add_argument('--n_discretesgd', type=int, default=0, help="number of discrete sgd (0 is not discrete sgd)")

    args = parser.parse_args()
    return args
