import gzip
import copy
import pickle
import os.path
import sys

import numpy as np

import matplotlib.pyplot as plt

from tqdm import tqdm
import torch
from torch import optim
from torch.utils.tensorboard import SummaryWriter
from torchvision import datasets, transforms
from torch.utils.data import DataLoader
from torchvision import datasets, transforms
import torch.nn as nn
import torch.nn.functional as F

from options import args_parser
from model import vae_mini

from torchvision.models import resnet18

from utils.cifar10_dataset import CIFAR10SubSet

""" TESTING on CIFAR-10"""

def get_schedulers(scheduler, optimizer, milestones=[30,80], gamma=0.5, T_max=10, lr_mul=0.001, d_model=10, n_warmup_steps=5):
    if scheduler == "step":
        return torch.optim.lr_scheduler.StepLR(optimizer, 30, gamma=gamma)
    elif scheduler == "cosine":
        return torch.optim.lr_scheduler.CosineAnnealingLR(optimizer, T_max)
    elif scheduler == "exponential":
        return torch.optim.lr_scheduler.ExponentialLR(optimizer, gamma=gamma)


def main():
    """Test SplitNN"""
    args = args_parser()
    lr = 1e-2
    epoch_max = 500
    epoch_finetune = 5
    bs = 32
    Q = 1
    num_class = 10

    train_size = 50000

    criterion = torch.nn.CrossEntropyLoss()
    device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
    print("Training on device", device)

    class Flatten(nn.Module):
        def __init__(self):
            super(Flatten, self).__init__()
            
        def forward(self, x):
            x = x.view(x.size(0), -1)
            return x

    ckp_vae = torch.load("/home/js905/code/cut_the_chain/saved_models_mi/1layer_vae.pt")
    ckp = torch.load("/home/js905/code/cut_the_chain/saved_models_adv/cifar10_resnet18_lambda0_init.pt")

    net = resnet18()
    net.fc = nn.Linear(net.fc.in_features, num_class)

    decoder = nn.Sequential(
            # input is Z
            nn.ConvTranspose2d(64, 3, 8, 2, 3),
            nn.Sigmoid())


    modules = list(net.children())[:3]
    head = nn.Sequential(*modules)

    vae = vae_mini(feature_volume = 64*16*16, z_size = 1024)

    head.load_state_dict(ckp_vae["head"])
    decoder.load_state_dict(ckp_vae["decoder"])
    vae.load_state_dict(ckp_vae["vae"])

    modules = list(net.children())[:-4]
    encoder = nn.Sequential(*modules)
    encoder.load_state_dict(ckp['encoder'])
    #modules = list(encoder.children())[3:]
    #encoder = nn.Sequential(*modules)

    modules = list(net.children())[-4:-1]
    clf = nn.Sequential(*[*modules, Flatten(), list(net.children())[-1]])
    clf.load_state_dict(ckp['clf'])


    head.to(device)
    decoder.to(device)
    vae.to(device)
    encoder.to(device)
    clf.to(device)




    transform_train = transforms.Compose(
         [transforms.ToTensor(),
          transforms.Normalize((0.5, 0.5, 0.5), (0.5, 0.5, 0.5))])
    transform_valid = transforms.Compose(
         [transforms.ToTensor(),
          transforms.Normalize((0.5, 0.5, 0.5), (0.5, 0.5, 0.5))])
    
    # transform_train = transforms.Compose(
    #      [transforms.ToTensor()])
    # transform_valid = transforms.Compose(
    #      [transforms.ToTensor()])

    tt = transforms.Compose(
         [transforms.Normalize((-0.5, -0.5, -0.5), (2, 2, 2)),
          transforms.ToPILImage()])
    #tt = transforms.ToPILImage()

    train_dataset = datasets.CIFAR10(
        root="../data/cifar10",
        train=True,
        download=True,
        transform=transform_train,
    ) 



    valid_dataset = datasets.CIFAR10(
        root="../data/cifar10",
        train=False,
        download=True,
        transform=transform_valid,
    )



    train_loader = torch.utils.data.DataLoader(
        train_dataset, batch_size=bs, shuffle=True, num_workers=2
    )

    valid_loader = torch.utils.data.DataLoader(
        valid_dataset, batch_size=bs, shuffle=False, num_workers=2
    )

    def valid_rec(head, decoder, data_loader, device):
        with torch.no_grad():
            mse_list = []
            for i, (inputs, labels) in enumerate(data_loader): 
                inputs, labels = inputs.to(device), labels.to(device)
                outputs = decoder(head(inputs))
                mse = F.mse_loss(outputs, inputs)

                mse_list.append(mse.item())
            metric = sum(mse_list) / len(mse_list)
        return metric

    def valid(head, vae, encoder, clf, data_loader, device, quit=False):
        encoder.eval()
        clf.eval()
 
        with torch.no_grad():
            correct, total = 0, 0
            for i, (inputs, labels) in enumerate(data_loader): 
                inputs, labels = inputs.to(device), labels.to(device)
                rep = head(inputs)
                (mu, logvar), rep = vae(rep)

                inputs_rec = decoder(rep)

                outputs = clf(encoder(inputs_rec))
                _, pred_label = torch.max(outputs.data, 1)

                total += inputs.data.size()[0]
                correct += (pred_label == labels.data).sum().item()
            metric = correct / float(total)
        return metric

    head.eval()

    train_acc = valid(head, vae, encoder, clf, train_loader, device)
    val_acc = valid(head, vae, encoder, clf, valid_loader, device)

    print(f"train_acc: {train_acc:.4f}, val_acc: {val_acc:.4f}")







if __name__ == "__main__":
    main()
