function V = br(M,opts)
	% Return the optimal value function and policy for a given population (distribution M)
	if ~isfield(opts, 'tol_br') tol = 1e-2; else tol = opts.tol_br; end
	if ~isfield(opts, 'type') type = 'optimize'; else type = opts.type; end
	% policy to evaluate
	if strcmp(type, 'evaluate') 
		if ~isfield(opts, 'policy')
			error('Policy not provided');
		end
		Q = opts.policy;
	end

	S = size(M, 1);
	A = reshape(1:S,S,1);
	V = zeros(size(M)); % initial value function
    filter = opts.filter;

	iter = 1;
	while iter <= 1e3
		iter = iter + 1;
		V_old = V;
		for i =1:S
			r_arr = opts.r(i,A,M);
            num = sum(filter(i,:) == 1);
			V_soft = sum((opts.filter(i,:)==1)' .* V_old) / num;
			rV = r_arr + opts.gamma * ((1-opts.soft) * V_old + opts.soft * V_soft);
			if strcmp(type, 'optimize')
				rV(opts.filter(i,:) ~= 1,:,:) = -inf;
				V(i,:,:) = max(rV);
			elseif strcmp(type, 'evaluate')
				filtered_Q = reshape(Q(i,:,:,:),[size(Q,2),size(Q,3),size(Q,4)]);
				filtered_Q(opts.filter(i,:) ~= 1,:,:) = -inf;
				% a = opts.softmax(filtered_Q,opts.temp);
				a = (filtered_Q == max(filtered_Q,[],1)); a = a ./ sum(a,1);
				V(i,:,:) = sum(a .* rV);
			end
		end
		if norm(V(:) - V_old(:), Inf)  < tol
			break;
		end
	end
	if iter >= 1e3; fprintf('max iterations for br\n'); end
	% disp(norm(V(:) - V_old(:), Inf) );
	% disp(iter);
end
