function M = ip(Q,opts)
	% Return the induced population given a policy (speed u)
	% tol is the tolerance for the convergence 

	if nargin < 2 || ~isfield(opts, 'tol_ip'); tol = 1e-3; else tol = opts.tol_ip; end
	% opts.soft = 0.5;

	filter = opts.filter;
	S = size(Q,1);
	M = ones(size(Q,[1,3,4])) * 1/S;

	% Construct transition matrix
	P = zeros(size(Q));
	for s = 1:S
		num = sum(filter(s,:));
		P(s,filter(s,:) == 1,:,:) = opts.soft/num;
		filtered_Q = squeeze(Q(s,:,:,:));
		if size(filtered_Q,1) == 1; filtered_Q = filtered_Q'; end
		filtered_Q(opts.filter(s,:) ~= 1,:,:) = -inf;
		% a = opts.softmax(filtered_Q, opts.temp); % a probability vector
		a = (filtered_Q == max(filtered_Q,[],1)); a = a ./ sum(a);
		P(s,:,:,:) = P(s,:,:,:) + (1-opts.soft) * reshape(a,[1,size(a)]);
	end
	Pinf = P;

	iter = 1;
	while iter <= 1e3
		iter = iter + 1;
		Pinf_old = Pinf;
		Pinf = pagemtimes(Pinf,P);
		% M_new = zeros(size(M));
		% for s = 1:S
		% 	filtered_Q = squeeze(Q(s,:,:,:));
		% 	if size(filtered_Q,1) == 1; filtered_Q = filtered_Q'; end
		% 	filtered_Q(opts.filter(s,:) ~= 1,:,:) = -inf;
		% 	% a = opts.softmax(filtered_Q, opts.temp); % a probability vector
		% 	a = (filtered_Q == max(filtered_Q,[],1)); a = a ./ sum(a);
		% 	a_soft = (opts.filter(s,:) == 1)'; a_soft = a_soft / sum(a_soft);
		% 	M_new = M_new + ((1-opts.soft) * a + opts.soft * a_soft) .* M(s,:,:);
		% end
		diff = norm(Pinf_old(:) - Pinf(:), Inf);
		if diff < tol; break; end
	end
	if iter >= 1e3; fprintf('max iterations for ip\n'); end
	% disp(diff); disp(iter);

	M = Pinf(1,:,:,:);
	M = reshape(M,[size(M,2),size(M,3),size(M,4)]);
end

