function [m_opt,v_opt,q_opt] = opt(opts)
iters = 100;
S = opts.S;
m = rand(S,1);
m = m/sum(m);
V = rand(S,1);
m_hist = zeros(S,iters);
v_hist = zeros(S,iters);
q_hist = zeros(S,S,iters);
A = reshape(1:S,S,1);
stop_flag = 0;

for iter=1:iters
	if mod(iter, 10) == 0 disp(iter); end
	V_old = V;
	V = br(m, opts);
	V_hist(:,iter)=V;
	V_diff = norm(V(:)-V_old(:),Inf) / norm(V_old(:), Inf);
	% OMD
	V = squeeze(sum(V_hist, 2))/iter;

	% Construct Q from V
	Q = -inf(size(V,[1,1,2,3]));
	for s=1:S
		V_soft = mean((opts.filter(s,:)==1)' .* V);
		Q(s,:,:,:) = opts.r(s,A,m) + opts.gamma * ((1-opts.soft) * V + opts.soft * V_soft);
		Q(s,opts.filter(s,:) ~= 1, :, :) = -inf;
	end
	% V_diff = expl(Q,opts) / 1e2;
	q_hist(:,:,iter) = Q;

	m_old = m;
	m = ip(Q, opts);
	m_diff = norm(m(:) - m_old(:), Inf);
	m_hist(:,iter)=m;
	% FP
	m = squeeze(sum(m_hist, 2))/iter;
	
	if max(m_diff, V_diff) < 1e-1
		stop_flag = stop_flag + 1;
	else
		stop_flag = 0;
	end
	if stop_flag > 3
		break;
	end
end

m_opt = m;
v_opt = V;
q_opt = Q;
disp(expl(q_opt,opts));
figure; plot_graph(m_opt,opts.model);
figure; plot(expl(q_hist,opts));
