function [Gr,p] = plot_graph(M,model)
	G = double(model.G);
	S = size(M,1);
	for s = 1:S-1
			G(model.G == s) = M(s+1)+ 1e-15;
	end
	Gr = digraph(G);
	p = plot(Gr);
	p.LineWidth = Gr.Edges.Weight * 1e2;
	p.EdgeCData = Gr.Edges.Weight * 1e2;
	p.NodeFontSize = 14;
	labelnode(p,[1 20],{'origin' 'dest'})
	cb = colorbar();
	cb.Label.String = "density";
	cb.Label.Rotation = 270;
	cb.Label.VerticalAlignment = "bottom";
	ax = gca;
	% scheme = color();
	% colormap(ax,flipud(scheme));
