%% Defaults
% Defaults for axes
set(0, 'DefaultAxesFontSize', 15, 'DefaultAxesFontName', 'times', 'DefaultAxesFontWeight', 'bold', 'DefaultAxesLineWidth', 1.5)
% Defaults for plots
set(0, 'DefaultLineLineWidth', 2, 'DefaultAxesLineStyleOrder', '.-', 'DefaultLineMarkerSize', 20)
set(0, 'DefaultLineMarker', 'none')
% Defaults for text
set(0, 'DefaultTextInterpreter', 'latex', 'DefaultTextFontName', 'times', 'DefaultTextFontWeight', 'bold')
% Defaults for legend
set(0, 'DefaultLegendInterpreter', 'latex')
set(0,'DefaultFigureColormap',interp1([1 2], [33, 102, 172; 178, 24, 43] / 255, 1:0.01:2));
colors = [77, 175, 74; 55, 126, 184; 228, 26, 28]  / 255;

%%
if ismember('graph', plot_list)
G = double(model.G);
G_opt = G;
for s = 1:S-1
    G(model.G == s) = M(s+1)+ 1e-15;
    G_opt(model.G == s) = m_opt(s+1)+ 1e-15;
end
Gr = digraph(G);
Gr_opt = digraph(G_opt);
f = figure;
% tiledlayout(1,2, 'TileSpacing', 'compact', 'Padding', 'none');
% nexttile
% p = plot(Gr);
% p.LineWidth = Gr.Edges.Weight * 1e2;
% p.EdgeCData = Gr.Edges.Weight * 1e2;
% labelnode(p,[1 20],{'origin' 'dest'})
% nexttile
% p = plot(Gr_opt);
% p.LineWidth = Gr_opt.Edges.Weight * 1e2;
% p.EdgeCData = Gr_opt.Edges.Weight * 1e2;
% labelnode(p,[1 20],{'origin' 'dest'})
% colorbar
% % sgtitle('Sioux Falls')
p = plot(Gr_opt);
p.LineWidth = Gr.Edges.Weight * 1e2;
p.EdgeCData = Gr.Edges.Weight * 1e2;
p.NodeFontSize = 14;
labelnode(p,[1 20],{'origin' 'dest'})
cb = colorbar();
cb.Label.String = "density";
cb.Label.Rotation = 270;
cb.Label.VerticalAlignment = "bottom";
exportgraphics(gca, '../fig/g/mu-opt.png', 'Resolution', 900)
savefig('../fig/g/mu-opt.fig')
end

%%
if ismember('population', plot_list)
figure(2)
plot(xx, [scale(smooth(M_avg)), scale(1./v_avg)], 'marker', 'none')
legend('learned population', 'induced population')
xlabel('state space', 'FontSize', 20)
ylabel('density', 'FontSize', 20)
title('Population', 'FontSize', 25)
% exportgraphics(gca, 'rho.png', 'Resolution', 900)
end

%%
if ismember('opt', plot_list)
figure(3)
plot(xx, [M_avg, M0] ./ del, 'marker', 'none')
legend('induced population', 'initial population')
xlabel('state space', 'FontSize', 20)
ylabel('density', 'FontSize', 20)
title('Population', 'FontSize', 25)
% exportgraphics(gca, 'rho_ini.png', 'Resolution', 900)
end

%%
if ismember('error', plot_list)
f = figure(3);
axis = gca;
if exist('err_on', 'var')
    varplot(err_fpi, 'marker', 'none', 'color', '#4daf4a')
    hold on
    varplot(err_off(1:2:end,:), 'marker', 'none', 'color', '#377eb8')
    hold on
    varplot(err_on, 'marker', 'none', 'color', '#e41a1c')
    legend('FPI', '', 'off-policy QMI', '', 'on-policy QMI', '')
    axis.Children(3).EdgeColor = 'none';
    axis.Children(5).EdgeColor = 'none';
else
    varplot(err_off(1:2:end,:), 'marker', 'none', 'color', '#b2182b')
    legend('QMI', '')
end
axis.Children(1).EdgeColor = 'none';
axis.YScale = 'log';
axis.XLim = [0, 50];
xlabel('iterations', 'FontSize', 20)
ylabel('MSE', 'FontSize', 20)
axis.Children(1).EdgeColor = 'none';
set(get(gca, 'XAxis'), 'Exponent', 0)
if save_flag
	exportgraphics(gca, '../fig/g/err.png', 'Resolution', 900)
	savefig('../fig/g/err.fig')
end
end


%% Exploitability
if ismember('expl', plot_list)
f = figure(4);
axis = gca;
if exist('expl_on', 'var')
    % expl_fpi_mean = mean(expl_fpi,2);
    % expl_fpi_std = std(expl_fpi,0,2);
    % varplot(expl_fpi_mean, max(1e-6, expl_fpi_mean-expl_fpi_std), expl_fpi_mean+expl_fpi_std, 'marker', 'none', 'color', '#4daf4a')
    varplot(expl_fpi, 'marker', 'none', 'color', '#4daf4a')
    hold on
    varplot(expl_off(1:2:end,:), 'marker', 'none', 'color', '#377eb8')
    hold on
    varplot(expl_on, 'marker', 'none', 'color', '#e41a1c')
    legend('FPI', '', 'off-policy QMI', '', 'on-policy QMI', '')
    axis.Children(3).EdgeColor = 'none';
    axis.Children(5).EdgeColor = 'none';
else
    varplot(expl_qmi(1:skip:end,:), 'marker', 'none', 'color', '#b2182b')
    legend('QMI', '')
end
axis.Children(1).EdgeColor = 'none';
axis.YScale = 'log';

xlabel('iterations', 'FontSize', 20)
ylabel('exploitability', 'FontSize', 20)
% sgtitle('Expl', 'FontSize', 25)
set(get(gca, 'XAxis'), 'Exponent', 0)
if save_flag
	exportgraphics(gca, '../fig/g/expl.png', 'Resolution', 900)
	savefig('../fig/g/expl.fig')
end
end

%% Sample compensation factor
if ismember('comp', plot_list)
    f = figure();
    axis = gca;
    varplot(err_fpi_line, 'r--', 'displayname', 'FPI')
    axis.Children(1).EdgeColor = 'none';
    axis.Children(1).FaceAlpha = 0.2;
    axis.Children(1).HandleVisibility = 'off';
    hold on
    for kappa = kappas
        err = results.(sprintf('kappa%d', kappa)).err;
        if strcmp(opts.policy, 'off')
            err = err(1:2:end,1:min(opts.epochs,10));
        end
        varplot(err, 'marker', 'none', 'displayname', sprintf('%d', kappa))
        hold on
        axis.Children(1).EdgeColor = 'none';
        axis.Children(1).FaceAlpha = 0.4;
        axis.Children(1).HandleVisibility = 'off';
    end
    axis.YScale = 'log';
    axis.XLim = [0, 50];
    legend
    title(legend,'$\eta$');
    xlabel('iterations', 'FontSize', 20)
    ylabel('MSE', 'FontSize', 20)
    set(get(gca, 'XAxis'), 'Exponent', 0)
    if save_flag
        exportgraphics(gca, sprintf('../fig/g/comp_err_%s.png', opts.policy), 'Resolution', 900)
        savefig(sprintf('../fig/g/comp_err_%s.fig', opts.policy))
    end

    f = figure();
    axis = gca;
    varplot(expl_fpi_line, 'r--', 'displayname', 'FPI')
    axis.Children(1).EdgeColor = 'none';
    axis.Children(1).FaceAlpha = 0.2;
    axis.Children(1).HandleVisibility = 'off';
    hold on
    for kappa = kappas
        expl = results.(sprintf('kappa%d', kappa)).expl;
        if strcmp(opts.policy, 'off')
            expl = expl(1:2:end,:);
        end
        varplot(expl, 'marker', 'none', 'displayname', sprintf('%d', kappa))
        hold on
        axis.Children(1).EdgeColor = 'none';
        axis.Children(1).FaceAlpha = 0.4;
        axis.Children(1).HandleVisibility = 'off';
    end
    axis.YScale = 'log';
    axis.XLim = [0, 50];
    legend
    title(legend,'$\eta$');
    xlabel('iterations', 'FontSize', 20)
    ylabel('exploitability', 'FontSize', 20)
    set(get(gca, 'XAxis'), 'Exponent', 0)
    if save_flag
        exportgraphics(gca, sprintf('../fig/g/comp_expl_%s.png', opts.policy), 'Resolution', 900)
        savefig(sprintf('../fig/g/comp_expl_%s.fig', opts.policy))
    end
end

%% T
if ismember('T', plot_list)
    f = figure();
    axis = gca;
    for T = Ts
        err = results.(sprintf('T%d', T)).err;
        if strcmp(opts.policy, 'off')
            err = err(1:2:end,:);
        end
        varplot(err(1:Ts(end)/T:end,:), 'marker', 'none', 'displayname', sprintf('%d', T))
        hold on
        axis.Children(1).EdgeColor = 'none';
        axis.Children(1).FaceAlpha = 0.2;
        axis.Children(1).HandleVisibility = 'off';
    end
    axis.XLim = [1, 10];
    axis.YScale = 'log';
    legend
    title(legend,'$T$');
    xlabel('iterations ($t\cdot k / 500$)', 'FontSize', 20)
    ylabel('MSE', 'FontSize', 20)
    % exportgraphics(gca, sprintf('../fig/g/t_err_%s.png', opts.policy), 'Resolution', 900)
    % savefig(sprintf('../fig/g/t_err_%s.fig', opts.policy))
    %
    f = figure();
    axis = gca;
    for T = Ts
        expl = results.(sprintf('T%d', T)).expl;
        if strcmp(opts.policy, 'off')
            expl = expl(1:2:end,:);
        end
        varplot(expl(1:Ts(end)/T:end,:), 'marker', 'none', 'displayname', sprintf('%d', T))
        hold on
        axis.Children(1).EdgeColor = 'none';
        axis.Children(1).FaceAlpha = 0.2;
        axis.Children(1).HandleVisibility = 'off';
    end
    axis.YScale = 'log';
    legend
    title(legend,'$T$');
    xlabel('iterations ($t\cdot k / 500$)', 'FontSize', 20)
    ylabel('Exploitability', 'FontSize', 20)
    % exportgraphics(gca, sprintf('../fig/g/t_expl_%s.png', opts.policy), 'Resolution', 900)
    % savefig(sprintf('../fig/g/t_expl_%s.fig', opts.policy))
end
