function [u,V,beta,pi,rho,u_hist,rho_hist] = value_iteration(model,demand,Nx,Nt,reward)
    M =model.E;
    N=model.N;
    E=model.E;
    n_iter=100;
    delta_t=1/Nx; %delta_t=delta_x can be relaxed
    u=zeros(M,Nx,Nt);
    rho=zeros(M,Nx,Nt);
    u_hist=zeros(n_iter,M,Nx,Nt);
    rho_hist=zeros(n_iter,M,Nx,Nt);
    V=zeros(M,Nx,Nt+1);
    pi=zeros(N,Nt+1);
    beta=zeros(E,Nt+1);
    beta_hist=zeros(n_iter,E,Nt+1);
    if model.E==5
        c3=zeros(model.E);
        c3(1)=1;
        c3(2)=1.5;
        c3(3)=1.5;
        c3(4)=1;
        c3(5)=1;
    elseif model.E==38
        c3=ones(model.E)*20;
        c3(2)=1;
        c3(3)=1;
        c3(4)=1;
        c3(10)=1;
        c3(12)=1;
        c3(14)=1;
        c3(30)=1;
        c3(31)=1;
        c3(32)=1;
    end
    %terminal cost for V and pi
    for l =1:M
        start_node=model.edges(l,1);
        end_node=model.edges(l,2);
        for j =1:Nx
            V(l,j,Nt+1)=model.Terminal(start_node)+(model.Terminal(end_node)-model.Terminal(start_node))*(j-1)/Nx;
        end
    end
    for node=1:N
        pi(node,Nt+1)=model.Terminal(node);
    end
    %value iteration 
    for iter=1:n_iter
        link_sequence=[1,3,2,5,4];
        if M==38
            link_sequence=[1,2,7,3,4,8,11,12,5,6,24,9,14,13,15,20,25,34,27,10,16,21,26,36,28,33,30,17,22,29,31,35,18,19,23,37,32,38];
        end
        %u,v update
        for t=1:Nt
            for se=1:M
                l=link_sequence(se);
                for j =1:Nx
                    if t==1
                        rho(l,j,t)=0;
                    else
                        if j>=2
                            rho(l,j,t)=rho(l,j,t-1)+rho(l,j-1,t-1)*u(l,j-1,t-1)-rho(l,j,t-1)*u(l,j,t-1);
                        else 
                            q_in=0;
                            start_node=model.edges(l,1);
                            if any(model.origins(:)==start_node) %origin node
                                q_in=q_in+demand(find(model.origins==start_node),t-1);
                            end
                            for k_in_node=1:model.N
                                k=model.G(k_in_node,start_node);
                                if k>0
                                    q_in=q_in+rho(k,Nx,t-1)*u(k,Nx,t-1);
                                end
                            end
                            entry=beta(l,t-1)*q_in;
                            rho(l,1,t)=rho(l,1,t-1)+entry-rho(l,1,t-1)*u(l,1,t-1);
                        end
                    end
                    % get u from rho
                    if j<Nx
                        if reward=="lwr"
                            temp=1-rho(l,j,t);
                            u(l,j,t)=min(max(0,temp),1);
                            V(l,j,t)=delta_t*(0.5*(1-u(l,j,t)-rho(l,j,t))^2)+(1-u(l,j,t))*V(l,j,t+1)+u(l,j,t)*V(l,j+1,t+1);
                        elseif reward=="non-sep"
                            temp=(V(l,j,t+1)-V(l,j+1,t+1))/delta_t-rho(l,j,t)+1;
                            u(l,j,t)=min(max(0,temp),1);
                            V(l,j,t)=delta_t*(0.5*u(l,j,t)^2+rho(l,j,t)*u(l,j,t)+c3(l)*1)+(1-u(l,j,t))*V(l,j,t+1)+u(l,j,t)*V(l,j+1,t+1);
                        elseif reward=="sep"
                            temp=(V(l,j,t+1)-V(l,j+1,t+1))/delta_t+1;
                            u(l,j,t)=min(max(0,temp),1);
                            V(l,j,t)=delta_t*(0.5*u(l,j,t)^2+rho(l,j,t)+c3(l)*1)+(1-u(l,j,t))*V(l,j,t+1)+u(l,j,t)*V(l,j+1,t+1);
                        end
                    else
                        end_node=model.edges(l,2);
                        if reward=="lwr"
                            temp=1-rho(l,j,t);
                            u(l,j,t)=min(max(0,temp),1);
                            V(l,j,t)=delta_t*(0.5*(1-u(l,j,t)-rho(l,j,t))^2)+(1-u(l,j,t))*V(l,j,t+1)+u(l,j,t)*pi(end_node,t+1);
                        elseif reward=="non-sep"
                            temp=(V(l,j,t+1)-pi(end_node,t+1))/delta_t-rho(l,j,t)+1;
                            u(l,j,t)=min(max(0,temp),1);
                            V(l,j,t)=delta_t*(0.5*u(l,j,t)^2+rho(l,j,t)*u(l,j,t)-u(l,j,t)+c3(l))+(1-u(l,j,t))*V(l,j,t+1)+u(l,j,t)*pi(end_node,t+1);
                        elseif reward=="sep"
                            temp=(V(l,j,t+1)-pi(end_node,t+1))/delta_t+1;
                            u(l,j,t)=min(max(0,temp),1);
                            V(l,j,t)=delta_t*(0.5*u(l,j,t)^2+rho(l,j,t)+c3(l)*1)+(1-u(l,j,t))*V(l,j,t+1)+u(l,j,t)*pi(end_node,t+1);
                        end 
                    end
                    u_hist(iter,l,j,t)=u(l,j,t);
                end
                u=squeeze(sum(u_hist,1))/iter;
                if model.E==1
                    temp=zeros(1,Nx,Nt);
                    temp(1,:,:)=u;
                    u=temp;
                end         
            end   
          
            %beta, pi update
            %recalulate
            %Initialize beta
            for node=1:N
                outlink=[];
                min_cost=inf;
                for k_out_node=1:model.N
                    k=model.G(node,k_out_node);
                    if k>0
                        outlink=[outlink,k];
                        if V(k,1,t)<=min_cost
                            min_cost=V(k,1,t);
                        %min_cost=min(min_cost,V(k,1,t));
                        %temp_link=k;
                        end
                    end
                end
                %beta(temp_link,t)=1;
                min_link=[];
                for i =1:length(outlink)
                    link=outlink(i);
                    if V(link,1,t)==min_cost
                        min_link=[min_link,link];
                    end
                end
                %calculate beta
                for j=1:length(min_link)
                    k=min_link(j);
                    beta(k,t)=1/length(min_link);
                end
                %calculate pi
                pi(node,t)=0;
                for i =1:length(outlink)
                    k=outlink(i);
                    pi(node,t)=pi(node,t)+beta(k,t)*V(k,1,t); %V at k link 1st cell
                end

            end
            beta_hist(iter,:,:,:)=beta;
            beta=squeeze(sum(beta_hist, 1))/iter;
            if model.E==1
                temp=zeros(1,E,Nt+1); 
                temp(1,:,:)=beta;
                beta=temp;
            end
            
        end
        rho_hist(iter,:,:,:)=rho(:,:,:);
        %u_hist(iter,:,:,:)=u(:,:,:);
    end    
end
