import glob
import json
import os
import random


def read_lama_jsonl(lama_jsonl):
    processed_data = []
    with open(lama_jsonl, 'r') as file:
        for line in file:
            record = json.loads(line)
            processed_data.append(record)
    return processed_data


def read_lama_json(lama_json):
    with open(lama_json, 'r') as file:
        data = json.load(file)
    return data



def combine_data_from_jsonl_files(directory, keyword=None):
    combined_data = []
    if keyword:
        for file_path in glob.glob(os.path.join(directory, f"*{keyword}*.jsonl")):
            with open(file_path, 'r') as file:
                for line in file:
                    combined_data.append(json.loads(line))
    else:
        for file_path in glob.glob(os.path.join(directory, "*.jsonl")):
            with open(file_path, 'r') as file:
                for line in file:
                    combined_data.append(json.loads(line))
    return combined_data



def get_unrelated_fact(KEYS, uuid):
    n_keys = len(KEYS)
    while True:
        random_uuid = KEYS[random.randint(0, n_keys - 1)]
        if random_uuid == uuid:
            continue
        return random_uuid











