import argparse
import json
import numpy as np
from collections import defaultdict
import scipy.stats as stats
import os
import datetime

parser = argparse.ArgumentParser(description='A tutorial of argparse!')
parser.add_argument("--save_file_dir", default='./g20_setup/', help="Path to save factory setup json files")
parser.add_argument("--seed", default=0, help="Set the random seed")
args = parser.parse_args()

np.random.seed(args.seed)

id = '{date:%Y-%m-%d-%H}'.format(date=datetime.datetime.now())

save_dir = args.save_file_dir+id

if not os.path.exists(save_dir):
    os.makedirs(save_dir)

n_head_types = 10

n_seq_steps = 20

num_stations = 24

fit_alpha, fit_loc, fit_beta = 0.8319306209481123, 1.2985144823146346, 26.17065110149774

dfit_alpha, dfit_loc, dfit_beta = 0.524386479195013, -1.0610137500367203e-28, 7.201557688154551

xfactor = 2

head_types = []
for i in range(n_head_types):
    head_types.append('ht' + str(i))

ht_dem = {ht: 10 for ht in head_types}

print(ht_dem)

stationsl = []
for i in range(num_stations):
    stationsl.append('st'+str(i))

recipesd = defaultdict(list)

for ht in head_types:
    for i in range(n_seq_steps):
        recipesd[ht].append([np.random.choice(stationsl), stats.gamma.rvs(fit_alpha, loc=fit_loc, scale=fit_beta, size=1)[0]])

rrecipes = dict(recipesd)

tproct = {ht: 0 for ht in head_types}


for ht in head_types:
    for step in rrecipes[ht]:
        tproct[ht] += step[1]

htstatct = {ht: {stat: 0 for stat in stationsl} for ht in recipesd.keys()}
proc_ts = []
for ht in recipesd.keys():
    for step in recipesd[ht]:
        htstatct[ht][step[0]] += step[1]
        proc_ts.append(step[1])

htstatdem = {ht: {stat: 0 for stat in stationsl} for ht in head_types}

for ht in head_types:
    for stat in stationsl:
        htstatdem[ht][stat] = htstatct[ht][stat]*ht_dem[ht]

statdem = {stat: 0 for stat in stationsl}

for ht in head_types:
    for stat in stationsl:
        statdem[stat] += htstatdem[ht][stat]

statmachmpd = {stat: 1440 for stat in stationsl}

statmachdem = {}
for stat in stationsl:
    statmachdem[stat] = int(np.ceil(statdem[stat]/statmachmpd[stat]))

rmachine_dict = {}

for stat in stationsl:
    for i in range(statmachdem[stat]):
        rmachine_dict[stat + '-' + str(i)] = stat

rbreak_repair_WIP = {'break_mean': None, 'repair_mean': 102, 'n_batch_wip': 5}
rlead_dict = {}
for ht in head_types:
    rlead_dict[ht] = xfactor*tproct[ht]

rpart_mix = {}

for ht in head_types:
    rpart_mix[ht] = 1

print('Generated Factory Files')

print(rbreak_repair_WIP)
print(rmachine_dict)
print(rrecipes)
print(rlead_dict)
print(rpart_mix)
print(len(rmachine_dict))

with open(save_dir+'/break_repair_wip.json', 'w') as fp:
    json.dump(rbreak_repair_WIP, fp)

with open(save_dir+'/machines.json', 'w') as fp:
    json.dump(rmachine_dict, fp)

with open(save_dir+'/recipes.json', 'w') as fp:
    json.dump(rrecipes, fp)

with open(save_dir+'/due_date_lead.json', 'w') as fp:
    json.dump(rlead_dict, fp)

with open(save_dir+'/part_mix.json', 'w') as fp:
    json.dump(rpart_mix, fp)



