# Makefile for CMLR project

# Name of the conda environment
ENV_NAME := cmlr-env

# The yml file that defines the conda environment
ENV_FILE := environment.yml

# Requirements file for pip
REQ_FILE := requirements.txt

# Default target
.PHONY: all
all: help

#----------------------------------------
# 1) Create the conda environment
#----------------------------------------
.PHONY: env
env:
	@echo "Creating conda environment '$(ENV_NAME)' from $(ENV_FILE)..."
	conda env create -f $(ENV_FILE) --name $(ENV_NAME)

#----------------------------------------
# 2) Install pip requirements into the active env
#----------------------------------------
.PHONY: deps
deps:
	@echo "Installing pip requirements from $(REQ_FILE)..."
	pip install -r $(REQ_FILE)

#----------------------------------------
# 3) Install this package in editable mode
#----------------------------------------
.PHONY: install
install: deps
	@echo "Installing local package in editable mode..."
	pip install -e .

#----------------------------------------
# 4) Run Jupyter Lab
#----------------------------------------
.PHONY: notebook
notebook:
	@echo "Launching Jupyter Lab..."
	jupyter lab

#----------------------------------------
# 5) Clean up pyc files and caches
#----------------------------------------
.PHONY: clean
clean:
	@echo "Removing Python cache & notebook checkpoints..."
	find . -type f -name '*.pyc' -delete
	find . -type d -name '__pycache__' -exec rm -rf {} +
	find . -type d -name '.ipynb_checkpoints' -exec rm -rf {} +

#----------------------------------------
# 6) Help message
#----------------------------------------
.PHONY: help
help:
	@echo "Usage:"
	@echo "  make env         # create conda env '$(ENV_NAME)'"
	@echo "  make deps        # install pip requirements"
	@echo "  make install     # pip install -e . (after deps)"
	@echo "  make notebook    # launch Jupyter Lab"
	@echo "  make clean       # remove Python caches"
