#!/bin/bash

# get current time
ts=$(date +"%Y%m%dT%H%M%S")

# run training for ResNet20 model without stochastic regularization
for model in resnet20
do
    echo "python -u trainer2.py  --arch=$model  --save-dir=save_$model$ts |& tee -a log_$model$ts"
    python -u trainer2.py  --arch=$model  --save-dir=save_$model$ts |& tee -a log_$model$ts
done

# run training for ResNet20 dropout models
for model in resnet20dropout01 resnet20dropout02 resnet20dropout03 resnet20dropout04 resnet20dropout05 resnet20dropout06 resnet20dropout07 resnet20dropout08 resnet20dropout09
do
    echo "python -u trainer2.py  --arch=$model  --save-dir=save_$model$ts |& tee -a log_$model$ts"
    python -u trainer2.py  --arch=$model  --save-dir=save_$model$ts |& tee -a log_$model$ts
done

# run training for ResNet20 PCFF models
for model in resnet20pcff01 resnet20pcff02 resnet20pcff03 resnet20pcff04 resnet20pcff05 resnet20pcff06 resnet20pcff07 resnet20pcff08 resnet20pcff09 resnet20pcff
do
    echo "python -u trainer2.py  --arch=$model  --save-dir=save_$model$ts |& tee -a log_$model$ts"
    python -u trainer2.py  --arch=$model  --save-dir=save_$model$ts |& tee -a log_$model$ts
done
