## Real-world Video Demonstration of Manipulation Tasks

We present five video demonstrations showcasing robot manipulation in real-world environments. 
The setup features a robot arm equipped with a parallel gripper as the end-effector and a RealSense D415 camera for capturing RGB-D images of the workspace. 
Each task is performed multiple times, with the videos sped up. 

### Box

Video `box.mp4` features a box with a bar handle on top. 
The task description is "open the box", 
The task requires the robot to open the box by grasping the handle and moving upward. 
The success rate for this task is 10 out of 10.

### Door

Video `door.mp4` showcases a door with a round handle, articulated with the chest behind it. 
To prevent significant movement of the chest, some heavy items are placed inside. 
The task description is "open the door of the chest". 
The task requires the robot to open the door by grasping the round handle and moving backward away from the door.
The success rate for this task is 9 out of 10.

### Storagefurniture

Video `storagefurniture.mp4` features a piece of storage furniture with closets. 
The task description is "open the closet in the middle". 
The task requires the robot to open the middle closet by grasping the bar handle and moving backward away from the storage furniture. 
The success rate for this task is 9 out of 10. 

### Bucket

Video `bucket.mp4` features a bucket with a handle on top lid. 
The task description is "lift the bucket lid". 
The task requires the robot to lift the bucket lid by grasping the curved handle and moving upward. 
The success rate for this task is 5 out of 5.

### Pot

Video `pot.mp4` features a pot with a handle on top lid. 
The task description is "lift the pot lid". 
The task requires the robot to lift the pot lid by grasping the knob handle and moving upward. 
The success rate for this task is 5 out of 5.
