# Rare Text Semantics Were Always There in Your Diffusion Transformer

## Overview

This repository contains the implementation of our paper "Rare Text Semantics Were Always There in Your Diffusion Transformer" (NeurIPS 2025 Anonymous Submission).

## Features

- Text semantic space intervention for Stable Diffusion 3 and Flux models
  - Token Spacing
  - Residual Alignment

## Installation

### Environment Setup

```bash
# Create and activate conda environment
conda create --name tora --file dependency_conda.txt
conda activate tora

# Install pip dependencies
pip install -r dependency_pip.txt
```

## Usage

### Configuration

The framework uses Hydra for configuration management. Configuration files are stored in the `A_exps` directory.

### Running Experiments

For SD3 experiments:
```bash
python cli_sd3.py -cn <config_name> [+parameter=value] [parameter=new_value]
```

For Flux experiments:
```bash
python cli_flux.py -cn <config_name> [+parameter=value] [parameter=new_value]
```

### Example

```bash
# Run with specific configuration and set device to GPU 0
python cli_sd3.py -cn exp_for_sd3 alpha=1.2 +device=0
```

### Configuration Parameters

- `alpha`: Steering intensity
- `device`: GPU device ID
- `exp_name`: Experiment name
- `on_steering`: Enable/disable steering
- `on_prompt_pca`: Enable/disable PCA-based prompt manipulation

## Project Structure

- `src/`: Source code
  - `sd3/`: Stable Diffusion 3 implementation
  - `flux/`: Flux model implementation
  - `logic/`: Core analysis and manipulation logic
  - `gear/`: Utility functions and helpers
- `A_exps/`: Configuration files
- `B_datasets/`: Dataset files
