#!/usr/bin/env python3
"""
Rare Text Semantics Were Always There in Your Diffusion Transformer
Flux CLI Execution Script

This script provides a command-line interface for running experiments with the Flux model.
"""
import sys
import os

# Find the current script path
script_dir = os.path.dirname(os.path.abspath(__file__))
# Calculate the src directory path
src_dir = os.path.join(script_dir, "src")
if os.path.exists(src_dir):
    # Add src directory to sys.path if it exists
    if src_dir not in sys.path:
        sys.path.insert(0, src_dir)
else:
    # If src directory doesn't exist, the current directory might already be the root or has a different structure
    print(f"Warning: src directory not found at {src_dir}")
    print(f"Current sys.path: {sys.path}")

from flux.launch import main
# try:
#     from flux.launch import main
# except ImportError as e:
#     print(f"Error importing flux.launch: {e}")
#     print("Make sure you're running from the project root directory")
#     sys.exit(1)

if __name__ == "__main__":
    # Display a simple help message if no command line arguments are provided
    if len(sys.argv) == 1:
        print("ToRA - Flux Model Interface")
        print("Usage: python cli_flux.py -cn <config_name> [parameter=value]")
        print("Example: python cli_flux.py -cn basic_generation +device=0")
    
    # Run the main function from launch.py
    main()