import logging
import sys
import coloredlogs
from ezcolorlog.format import get_log_fmt
from ezcolorlog.notebook import ColoredFormatter, isnotebook
from ezcolorlog.config import load_cfg

def create_color_logger(name="my_ezlogger", cfg_file=None, level=logging.INFO):
    logger = logging.getLogger(name)
    logger.propagate = False
    logger.handlers[:] = []

    user, fmts, style = load_cfg(cfg_file)
    log_fmt = user.get("log_fmt", "standard")

    if isnotebook() or log_fmt == "notebook":
        handler = logging.StreamHandler(sys.stdout)
        handler.setFormatter(ColoredFormatter())
        logger.addHandler(handler)
        logger.setLevel(level)
        logger.info("Notebook-style ezcolorlog initialized (independent).")
    else:
        clfmt = get_log_fmt(log_fmt, fmts=fmts)
        coloredlogs.install(
            logger=logger, 
            level=level, 
            fmt=clfmt, 
            field_styles=style
        )
        logger.setLevel(logging.DEBUG)
        logger.info(f"'{log_fmt}' ezcolorlog initialized (independent).")

    return logger

clogger = create_color_logger()