#!/bin/bash

model=llava-v1.5-7b

python -m llava.eval.model_vqa \
    --model-path $model \
    --question-file ./playground/data/eval/mm-vet/llava-mm-vet.jsonl \
    --image-folder ./playground/data/eval/mm-vet/images \
    --answers-file ./playground/data/eval/mm-vet/answers/${model}.jsonl \
    --temperature 0 \
    --conv-mode vicuna_v1 \
    --vision-retracing default \
    --retracing-ratio 0.12 \
    --starting-layer 5 \
    --ending-layer 16 \

mkdir -p ./playground/data/eval/mm-vet/results

python scripts/convert_mmvet_for_eval.py \
    --src ./playground/data/eval/mm-vet/answers/${model}.jsonl \
    --dst ./playground/data/eval/mm-vet/results/${model}.json

