#!/bin/bash

model=llava-v1.5-7b

python -m llava.eval.model_vqa_loader \
    --model-path $model \
    --question-file ./playground/data/eval/vizwiz/llava_test.jsonl \
    --image-folder ./playground/data/eval/vizwiz/test \
    --answers-file ./playground/data/eval/vizwiz/answers/${model}.jsonl \
    --temperature 0 \
    --conv-mode vicuna_v1 \
    --vision-retracing default \
    --entropy_threshold 0.1 \
    --retracing-ratio 0.12 \
    --starting-layer 5 \
    --ending-layer 16 \

python scripts/convert_vizwiz_for_submission.py \
    --annotation-file ./playground/data/eval/vizwiz/llava_test.jsonl \
    --result-file ./playground/data/eval/vizwiz/answers/${model}.jsonl \
    --result-upload-file ./playground/data/eval/vizwiz/answers_upload/${model}.json
