#!/bin/bash

model=llava-v1.5-7b

python -m llava.eval.model_vqa \
    --model-path $model \
    --question-file ./playground/data/eval/llava-bench-in-the-wild/questions.jsonl \
    --image-folder ./playground/data/eval/llava-bench-in-the-wild/images \
    --answers-file ./playground/data/eval/llava-bench-in-the-wild/answers/${model}.jsonl \
    --temperature 0 \
    --conv-mode vicuna_v1 \
    --vision-retracing default \
    --retracing-ratio 0.12 \
    --starting-layer 5 \
    --ending-layer 16 \


mkdir -p playground/data/eval/llava-bench-in-the-wild/reviews

python llava/eval/eval_gpt_review_bench.py \
    --question playground/data/eval/llava-bench-in-the-wild/questions.jsonl \
    --context playground/data/eval/llava-bench-in-the-wild/context.jsonl \
    --rule llava/eval/table/rule.json \
    --answer-list \
        playground/data/eval/llava-bench-in-the-wild/answers_gpt4.jsonl \
        playground/data/eval/llava-bench-in-the-wild/answers/${model}.jsonl \
    --output \
        playground/data/eval/llava-bench-in-the-wild/reviews/${model}.jsonl

python llava/eval/summarize_gpt_review.py -f playground/data/eval/llava-bench-in-the-wild/reviews/${model}.jsonl
