#!/bin/bash

model=llava-v1.5-7b

python -m llava.eval.model_vqa_loader \
    --model-path $model \
    --question-file ./playground/data/eval/pope/llava_pope_test.jsonl \
    --image-folder ./playground/data/eval/pope/val2014 \
    --answers-file ./playground/data/eval/pope/answers/${model}.jsonl \
    --temperature 0 \
    --conv-mode vicuna_v1 \
    --vision-retracing default \
    --retracing-ratio 0.12 \
    --starting-layer 5 \
    --ending-layer 16 \

python llava/eval/eval_pope.py \
    --annotation-dir ./playground/data/eval/pope/coco \
    --question-file ./playground/data/eval/pope/llava_pope_test.jsonl \
    --result-file ./playground/data/eval/pope/answers/${model}.jsonl
