#!/bin/bash

model=llava-v1.5-7b

python -m llava.eval.model_vqa_loader \
    --model-path $model \
    --question-file ./playground/data/eval/MME/llava_mme.jsonl \
    --image-folder ./playground/data/eval/MME/MME_Benchmark_release_version \
    --answers-file ./playground/data/eval/MME/answers/${model}.jsonl \
    --temperature 0 \
    --conv-mode vicuna_v1 \
    --vision-retracing default \
    --retracing-ratio 0.12 \
    --starting-layer 5 \
    --ending-layer 16 \

cd ./playground/data/eval/MME

python convert_answer_to_mme.py --experiment ${model}

cd eval_tool

python calculation.py --results_dir answers/${model}
