REAL_DATA_DIR="/path/to/dataset"

# List of directories containing the generated NIfTI files to evaluate.
# The first directory listed will be treated as the baseline for statistical tests.
GEN_DATA_DIRS=(
    "/path/to/generated/samples/RFM_Steps_10/FlowLetAblation_RFM_Baseline_AgeLin_5.9-95.5_Steps10"
    "/path/to/generated/samples/RFM_Steps_2/FlowLetAblation_RFM_Baseline_AgeLin_5.9-95.5_Steps2"
    "/path/to/generated/samples/RFM_Steps_5/FlowLetAblation_RFM_Baseline_AgeLin_5.9-95.5_Steps5"
    "/path/to/generated/samples/RFM_Steps_1/FlowLetAblation_RFM_Baseline_AgeLin_5.9-95.5_Steps1"
    "/path/to/generated/samples/RFM_Steps_200/FlowLetAblation_RFM_Baseline_AgeLin_5.9-95.5_Steps200"

    "/path/to/generated/samples/CFM_Steps_1/FlowLetAblation_CFM_Baseline_AgeLin_5.9-95.5_Steps1"
    "/path/to/generated/samples/CFM_Steps_2/FlowLetAblation_CFM_Baseline_AgeLin_5.9-95.5_Steps2"
    "/path/to/generated/samples/CFM_Steps_5/FlowLetAblation_CFM_Baseline_AgeLin_5.9-95.5_Steps5"
    "/path/to/generated/samples/CFM_Steps_10/FlowLetAblation_CFM_Baseline_AgeLin_5.9-95.5_Steps10"
    "/path/to/generated/samples/CFM_Steps_200/FlowLetAblation_CFM_Baseline_AgeLin_5.9-95.5_Steps200"

    "/path/to/generated/samples/VP_Steps_1/FlowLetAblation_VP_Baseline_AgeLin_5.9-95.5_Steps1"
    "/path/to/generated/samples/VP_Steps_2/FlowLetAblation_VP_Baseline_AgeLin_5.9-95.5_Steps2"
    "/path/to/generated/samples/VP_Steps_5/FlowLetAblation_VP_Baseline_AgeLin_5.9-95.5_Steps5"
    "/path/to/generated/samples/VP_Steps_10/FlowLetAblation_VP_Baseline_AgeLin_5.9-95.5_Steps10"
    "/path/to/generated/samples/VP_Steps_200/FlowLetAblation_VP_Baseline_AgeLin_5.9-95.5_Steps200"

    "/path/to/generated/samples/Trigonometric_Steps_1/FlowLetAblation_Trigonometric_Baseline_AgeLin_5.9-95.5__Steps1"
    "/path/to/generated/samples/Trigonometric_Steps_2/FlowLetAblation_Trigonometric_Baseline_AgeLin_5.9-95.5__Steps2"
    "/path/to/generated/samples/Trigonometric_Steps_5/FlowLetAblation_Trigonometric_Baseline_AgeLin_5.9-95.5__Steps5"
    "/path/to/generated/samples/Trigonometric_Steps_10/FlowLetAblation_Trigonometric_Baseline_AgeLin_5.9-95.5__Steps10"
    "/path/to/generated/samples/Trigonometric_Steps_200/FlowLetAblation_Trigonometric_Baseline_AgeLin_5.9-95.5__Steps200"

    "/path/to/generated/samples/FlowLetAblation_RFM_Baseline_unconditional_Steps10"
    "/path/to/generated/samples/FlowLetAblation_FiLM_Only_AgeLin_5.9-95.5_Steps10"
    "/path/to/generated/samples/FlowLetAblation_CrossAttn_Only_AgeLin_5.9-95.5_Steps10"

    "/path/to/generated/samples/WDM_Baseline"
    "/path/to/generated/samples/Monai_AEK_LDM_baseline"
    "/path/to/generated/samples/MedicalDiffusion_baseline"
)

# Path to the pretrained MedicalNet ResNet-50 weights for the feature extractor.
MEDICAL_RESNET_PATH="/path/to/MED3D_pretrained_weights/resnet_50_epoch_110_batch_0.pth"

# Path for the final output CSV file.
OUTPUT_CSV_FILE="./Evaluation/FlowLet_Comprehensive_Benchmark_Results.csv"

# Log file for this evaluation run.
LOG_FILE="./Evaluation/FlowLet_Comprehensive_Benchmark_Results.log"

# --- Evaluation Parameters ---

# Maximum number of generated samples to select from each directory using a stride.
MAX_FID_SAMPLES=500
MAX_SSIM_SAMPLES=200
# Number of random bootstrap iterations for calculating Mean and Standard Deviation.
NUM_BOOTSTRAPS=100

BATCH_SIZE=16

# --- Execution ---

# Create the logs directory if it doesn't exist.
mkdir -p logs

# Convert the bash array of directories into a space-separated string for the command line.
GEN_DIRS_STRING="${GEN_DATA_DIRS[*]}"

echo "Starting comprehensive evaluation..."
echo "Real data directory: ${REAL_DATA_DIR}"
echo "Generated data directories: ${GEN_DIRS_STRING}"
echo "Output will be saved to: ${OUTPUT_CSV_FILE}"
echo "Logging to: ${LOG_FILE}"

# Run the evaluation script in the background, redirecting output to the log file.
PYTHONPATH=. nohup python3 -u Evaluation_FID_MMD_MSSIM.py \
    --real_dir "${REAL_DATA_DIR}" \
    --gen_dirs ${GEN_DIRS_STRING} \
    --output_csv "${OUTPUT_CSV_FILE}" \
    --medical_resnet_path "${MEDICAL_RESNET_PATH}" \
    --batch_size ${BATCH_SIZE} \
    --num_workers 8 \
    --device cuda \
    --max_fid_samples ${MAX_FID_SAMPLES} \
    --max_ssim_samples ${MAX_SSIM_SAMPLES} \
    --num_bootstraps ${NUM_BOOTSTRAPS} \
    --mmd_sigma 5.0 \
    > "${LOG_FILE}" 2>&1 &