# MRI Preprocessing Pipeline

This directory contains the scripts necessary to perform the standardized MRI preprocessing described in the paper. Running this pipeline on your raw MRI data is a **required first step** before training a FlowLet model.

The goal of this pipeline is to prepare a heterogeneous collection of 3D T1w MRI scans (e.g., from ADNI, OASIS, etc.) into a consistent, normalized format suitable for deep learning.

## Preprocessing Steps

The `preprocessing_parallel.sh` script automates the following key steps for each input MRI scan:

1.  **Bias Field Correction:** Uses `ants.N4BiasFieldCorrection` to correct for low-frequency intensity non-uniformities that are common in MRI data. This ensures that voxel intensities are more consistent across the image.
2.  **Skull Stripping:** Employs FSL's `bet` (Brain Extraction Tool) to remove the skull, scalp, and other non-brain tissues from the image. This focuses the model's attention purely on the brain anatomy.
3.  **Resampling:** Resamples each volume to a common isotropic resolution and matrix size (91 x 109 x 91), ensuring all images in the dataset are aligned in the same physical space.
4.  **Intensity Normalization:** Clips voxel intensities to a standard range (e.g., 0-100) and normalizes them to prevent issues with varying scanner protocols and signal intensities.

## Requirements

The preprocessing pipeline relies on two external neuroimaging software packages: **ANTsPy** and **FSL**.

### 1. Environment Setup

It is highly recommended to create a dedicated Conda environment to manage these dependencies.

```bash
# Create and activate the new environment
conda create -n preprocessing_env python=3.11
conda activate preprocessing_env
```

### 2. ANTs (via antspyx)

ANTs (Advanced Normalization Tools) is used for bias field correction. You can install the Python wrapper easily using pip:

```bash
pip install antspyx
```

### 3. FSL (FMRIB Software Library)

FSL is required for the skull-stripping step. FSL must be installed system-wide. Please follow the official installation instructions for your operating system:

**Official FSL Installation Guide:** [https://fsl.fmrib.ox.ac.uk/fsl/fslwiki/FslInstallation](https://fsl.fmrib.ox.ac.uk/fsl/fslwiki/FslInstallation)

After installation, ensure that the FSL environment is properly configured in your shell (this is often handled by the installer by adding a line to your `.bashrc` or equivalent profile script). You can test the installation by opening a new terminal and running `fslinfo`.

## How to Run the Preprocessing

The main script `scripts/preprocessing_parallel.sh` is designed to process an entire dataset in parallel, significantly speeding up the workflow.


Once the script finishes, the specified `OUTPUT_DIR` will contain the fully preprocessed, training-ready 3D MRI scans. You can then proceed to the **next step of the FlowLet workflow**: creating the metadata CSV file using the scripts in the `Dataset_preparation/` directory.