






# coding=utf-8
# Copyright 2020-present the HuggingFace Inc. team.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""
The Trainer class, to easily train a 🤗 Transformers from scratch or finetune it on a new task.
"""

import contextlib
import functools
import glob
import inspect
import math
import os
import random
import wandb
import re
import shutil
import sys
import time
import warnings
from collections.abc import Mapping
from pathlib import Path
from typing import TYPE_CHECKING, Any, Callable, Dict, List, Optional, Tuple, Union
import copy
from metrics import f1
from collections import deque
import numpy as np
from lr_scheduler import zo_lr_scheduler

from tqdm.auto import tqdm
from transformers import Trainer
from sklearn.linear_model import LinearRegression, LogisticRegression, LogisticRegressionCV
from collections import deque

# Integrations must be imported before ML frameworks:
from transformers.integrations import (  # isort: split
    default_hp_search_backend,
    get_reporting_integration_callbacks,
    hp_params,
    is_fairscale_available,
    is_optuna_available,
    is_ray_tune_available,
    is_sigopt_available,
    is_wandb_available,
    run_hp_search_optuna,
    run_hp_search_ray,
    run_hp_search_sigopt,
    run_hp_search_wandb,
)

import numpy as np
import torch
import torch.distributed as dist
from packaging import version
from torch import nn
from torch.utils.data import DataLoader, Dataset, RandomSampler, SequentialSampler
from torch.utils.data.distributed import DistributedSampler
from torch.amp import autocast

from huggingface_hub import Repository

from transformers import __version__
from transformers.configuration_utils import PretrainedConfig
from transformers.data.data_collator import DataCollator, DataCollatorWithPadding, default_data_collator
from transformers.debug_utils import DebugOption, DebugUnderflowOverflow
from transformers.deepspeed import deepspeed_init, is_deepspeed_zero3_enabled
from transformers.dependency_versions_check import dep_version_check
from transformers.modelcard import TrainingSummary
from transformers.modeling_utils import PreTrainedModel, load_sharded_checkpoint, unwrap_model
from transformers.models.auto.modeling_auto import MODEL_FOR_CAUSAL_LM_MAPPING_NAMES, MODEL_MAPPING_NAMES
from transformers.optimization import Adafactor, get_scheduler
from transformers.pytorch_utils import ALL_LAYERNORM_LAYERS, is_torch_greater_or_equal_than_1_10, \
    is_torch_less_than_1_11
from transformers.tokenization_utils_base import PreTrainedTokenizerBase
from transformers.trainer_callback import (
    CallbackHandler,
    DefaultFlowCallback,
    PrinterCallback,
    ProgressCallback,
    TrainerCallback,
    TrainerControl,
    TrainerState,
)
from transformers.trainer_pt_utils import (
    DistributedLengthGroupedSampler,
    DistributedSamplerWithLoop,
    DistributedTensorGatherer,
    IterableDatasetShard,
    LabelSmoother,
    LengthGroupedSampler,
    SequentialDistributedSampler,
    ShardSampler,
    distributed_broadcast_scalars,
    distributed_concat,
    find_batch_size,
    get_module_class_from_name,
    get_parameter_names,
    nested_concat,
    nested_detach,
    nested_numpify,
    nested_truncate,
    nested_xla_mesh_reduce,
    reissue_pt_warnings,
)
from transformers.trainer_utils import (
    PREFIX_CHECKPOINT_DIR,
    BestRun,
    EvalLoopOutput,
    EvalPrediction,
    FSDPOption,
    HPSearchBackend,
    HubStrategy,
    IntervalStrategy,
    PredictionOutput,
    RemoveColumnsCollator,
    ShardedDDPOption,
    TrainerMemoryTracker,
    TrainOutput,
    default_compute_objective,
    default_hp_space,
    denumpify_detensorize,
    enable_full_determinism,
    find_executable_batch_size,
    get_last_checkpoint,
    has_length,
    number_of_arguments,
    seed_worker,
    set_seed,
    speed_metrics,
)
from transformers.training_args import OptimizerNames, ParallelMode, TrainingArguments
from transformers.utils import (
    CONFIG_NAME,
    WEIGHTS_INDEX_NAME,
    WEIGHTS_NAME,
    find_labels,
    get_full_repo_name,
    is_apex_available,
    is_datasets_available,
    is_in_notebook,
    is_ipex_available,
    is_sagemaker_dp_enabled,
    is_sagemaker_mp_enabled,
    is_torch_tensorrt_fx_available,
    is_torch_tpu_available,
    is_torchdynamo_available,
    logging,
)
from transformers.utils.generic import ContextManagers
from scipy.special import loggamma
from Hessian_smooth_scheduler import Hessian_smooth_scheduler

from transformers.modeling_outputs import CausalLMOutputWithPast
from torch.nn import CrossEntropyLoss
from torch.optim.lr_scheduler import LambdaLR

_is_native_cpu_amp_available = is_torch_greater_or_equal_than_1_10

DEFAULT_CALLBACKS = [DefaultFlowCallback]
DEFAULT_PROGRESS_CALLBACK = ProgressCallback

if is_in_notebook():
    from .utils.notebook import NotebookProgressCallback

    DEFAULT_PROGRESS_CALLBACK = NotebookProgressCallback

if is_apex_available():
    from apex import amp

if is_datasets_available():
    import datasets
import torch.optim as optim

if is_torch_tpu_available(check_device=False):
    import torch_xla.core.xla_model as xm
    import torch_xla.debug.metrics as met
    import torch_xla.distributed.parallel_loader as pl

if is_fairscale_available():
    dep_version_check("fairscale")
    import fairscale
    from fairscale.nn.data_parallel import FullyShardedDataParallel as FullyShardedDDP
    from fairscale.nn.data_parallel import ShardedDataParallel as ShardedDDP
    from fairscale.nn.wrap import auto_wrap
    from fairscale.optim import OSS
    from fairscale.optim.grad_scaler import ShardedGradScaler
from utils import encode_prompt, Prediction

if is_sagemaker_mp_enabled():
    import smdistributed.modelparallel.torch as smp
    from smdistributed.modelparallel import __version__ as SMP_VERSION

    IS_SAGEMAKER_MP_POST_1_10 = version.parse(SMP_VERSION) >= version.parse("1.10")

    from .trainer_pt_utils import smp_forward_backward, smp_forward_only, smp_gather, smp_nested_concat
else:
    IS_SAGEMAKER_MP_POST_1_10 = False

if TYPE_CHECKING:
    import optuna

from torch.profiler import profile, ProfilerActivity, tensorboard_trace_handler

logger = logging.get_logger(__name__)

# Name of the files used for checkpointing
TRAINING_ARGS_NAME = "training_args.bin"
TRAINER_STATE_NAME = "trainer_state.json"
OPTIMIZER_NAME = "optimizer.pt"
SCHEDULER_NAME = "scheduler.pt"
SCALER_NAME = "scaler.pt"

from tasks import get_task
import torch.nn.functional as F
from metrics import calculate_metric
from collections import defaultdict
from torchprofile import profile_macs


CLIPMIN = 1e-4





def kernel_function(r, beta=4):
 
    #return 12*r
    return (15*r) * (5 - 7*(r)**2)
    #return (195*r/64) * (99*(r)**4 - 126*(r)**2 + 35)















class OurTrainer(Trainer):
    from transformers.trainer_pt_utils import _get_learning_rate, log_metrics, metrics_format, save_metrics, save_state

    ##################################加量化

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
 
        self.param_quantizer = UniformAffineQuantizer(
            n_bits=16,
            symmetric=True,
            disable_zero_point=True,  # <-- 修改这里
            dynamic=True,
            lwc=False
        )

    def _dequant_cparam(self, name):
        """
        从 INT8 snapshot 反量化回原始 param 的 dtype（支持 bf16/fp16/fp32）。
        """
      
        int8_t, scale, zp = dict(self.named_parameters_to_optim_copy)[name]
   
        scale_f = scale.to(torch.bfloat16)
        if zp is None:
            deq_f32 = int8_t.to(torch.bfloat16) * scale_f
        else:
            zp_f = zp.to(torch.bfloat16)
            deq_f32 = (int8_t.to(torch.bfloat16) - zp_f) * scale_f
      
        orig_param = dict(self.named_parameters_to_optim)[name]
   
        return deq_f32.to(device=orig_param.device, dtype=orig_param.dtype)
    

    def _quantize_param(self, param_tensor, device):
     
        param_tensor_on_device = param_tensor.to(device)
        
        self.param_quantizer.per_token_dynamic_calibration(param_tensor_on_device)
        scale = self.param_quantizer.scale.clone().to(device)
        
        quantized_val = (param_tensor_on_device / scale).round()
        quantized_val.clamp_(self.param_quantizer.qmin, self.param_quantizer.qmax)

        int16_t = quantized_val.to(torch.int16)
        #int8_t = quantized_val.to(torch.int8)
        
        zp = self.param_quantizer.round_zero_point
        if zp is not None:
            zp = zp.clone().to(device)

        if self.state.global_step == 0:
    
            print(f"DEBUG: Tensor shape {param_tensor.shape}, Avg. Scale: {scale.mean().item():.6f}")
            
            
        return int16_t, scale, zp

    def _dequantize_snap(self, snap, device):
    
        int16_t, scale, zp = snap
        
        deq_val = int16_t.to(device=device, dtype=torch.float16)
        scale_on_device = scale.to(device=device, dtype=torch.float16)
        
        if zp is not None:
            zp_on_device = zp.to(device=device, dtype=torch.float16)
            deq_val = deq_val - zp_on_device
        
        c_bf16 = deq_val * scale_on_device
        return c_bf16


    def _inner_training_loop(
            self, batch_size=None, args=None, resume_from_checkpoint=None, trial=None, ignore_keys_for_eval=None
    ):
        """
        We overload the original training loop to add linear probing and MeZO. Search key word "MeZO added"
        for those updates.
        """

        self.eval_loss_list = []
        self.window       = 100  #args.window
        self.k_probe      = 20    #args.k_probe
        self.rank_r       = 128   #args.rank_r

        self.init_delta  = 2.0
        self.final_delta = 0.1
        self.dap_delta = 1.0
     
        # t = self.state.global_step / max_steps
        # self.dap_delta = self.init_delta * (1 - t) + self.final_delta * t

        self.subspace_step0 = 0                
        self.G_cache      = dict()            
        self.eval_loss_list = []
        self.beta_k = 1
        self.p_state = dict()
        self.update_steps = 0
        self.beta_k = 1
        self.deepspeed = None
        self._train_batch_size = batch_size
        # Data loader and number of training steps
        train_dataloader = self.get_train_dataloader()
        self.task = get_task(self.args.task_name)
        self.objective = 0
        # MeZO added: Linear probing
        if self.args.linear_probing:

            def _get_token_prediction_layer(model):
                if model.config.model_type == "opt":
                    return model.lm_head
                else:
                    raise NotImplementedError(model.config.model_type)

            def _extract_features(model, *args, **kwargs):
                """some magic for getting features pre last layer"""
                features = {}

                def __hook(model_, input_, output_):
                    features["features"] = input_[0].detach()

                _get_token_prediction_layer(model).register_forward_hook(__hook)
                model.forward(*args, **kwargs)
                return features["features"]

            logger.info("Linear probing")
            logger.info("Starting to get features for training dataset")
            targets = []
            features = []
            with torch.inference_mode():
                for step, inputs in enumerate(tqdm(train_dataloader)):
                    for k, v in inputs.items():
                        if isinstance(v, torch.Tensor):
                            inputs[k] = v.to(self.model.device)

                    feature = _extract_features(self.model, **inputs)
                    target = inputs["labels"]

                    # Shift the target (bc it's autoregressive LM) and add the corresponding part
                    assert not self.args.train_as_classification and self.args.only_train_option
                    feature, target = feature[:, :-1], target[:, 1:]
                    for _i, _len in enumerate(inputs["option_len"]):
                        features.append(feature[_i, -_len:])
                        targets.append(target[_i, -_len:])

            logger.info("Finished getting features for training dataset")

            features = torch.cat(features, dim=0).cpu().numpy()
            targets = torch.cat(targets, dim=0).cpu().numpy()
            # Whether to use bias
            if self.model.config.model_type in ["opt", "gpt2"]:
                use_bias = False
            else:
                raise NotImplementedError
            # Set early stopping
            tol = 0.01 if self.args.lp_early_stopping else 1e-4  # 1e-4 is scipy default
            max_iter = 1000 if self.args.lp_early_stopping else 5000

            logger.info("Fitting logistic regression...")
            reg = LogisticRegressionCV(max_iter=max_iter, fit_intercept=use_bias, multi_class="multinomial",
                                       random_state=0, tol=tol, n_jobs=-1).fit(features, targets)
            logger.info("Done")

            logger.info("Assigning weights to model")
            decoder = _get_token_prediction_layer(self.model)
            coef_torch = torch.tensor(reg.coef_, device=decoder.weight.device, dtype=decoder.weight.dtype)
            if use_bias:
                bias_torch = torch.tensor(reg.intercept_, device=decoder.weight.device, dtype=decoder.weight.dtype)
            if coef_torch.shape[0] == 1:  # The regressor only detects two classes
                assert len(reg.classes_) == 2
                coef_torch = torch.cat([-coef_torch / 2, coef_torch / 2], dim=0)
                if use_bias:
                    bias_torch = torch.cat([-bias_torch / 2, bias_torch / 2], dim=0)

            for _i, token_id in enumerate(reg.classes_):
                decoder.weight.data[token_id] = coef_torch[_i]
                if use_bias:
                    decoder.bias.data[token_id] = bias_torch[_i]

            return None

        # Setting up training control variables:
        # number of training epochs: num_train_epochs
        # number of training steps per epoch: num_update_steps_per_epoch
        # total number of training steps to execute: max_steps
        total_train_batch_size = args.train_batch_size * args.gradient_accumulation_steps * args.world_size

        len_dataloader = None
        if has_length(train_dataloader):
            len_dataloader = len(train_dataloader)
            num_update_steps_per_epoch = len_dataloader // args.gradient_accumulation_steps
            num_update_steps_per_epoch = max(num_update_steps_per_epoch, 1)
            num_examples = self.num_examples(train_dataloader)
            if args.max_steps > 0:
                max_steps = args.max_steps
                num_train_epochs = args.max_steps // num_update_steps_per_epoch + int(
                    args.max_steps % num_update_steps_per_epoch > 0
                )
                # May be slightly incorrect if the last batch in the training dataloader has a smaller size but it's
                # the best we can do.
                num_train_samples = args.max_steps * total_train_batch_size
            else:
                max_steps = math.ceil(args.num_train_epochs * num_update_steps_per_epoch)
                num_train_epochs = math.ceil(args.num_train_epochs)
                num_train_samples = self.num_examples(train_dataloader) * args.num_train_epochs
        elif args.max_steps > 0:  # Rely on max_steps when dataloader does not have a working size
            max_steps = args.max_steps
            # Setting a very large number of epochs so we go as many times as necessary over the iterator.
            num_train_epochs = sys.maxsize
            num_update_steps_per_epoch = max_steps
            num_examples = total_train_batch_size * args.max_steps
            num_train_samples = args.max_steps * total_train_batch_size
        else:
            raise ValueError(
                "args.max_steps must be set to a positive value if dataloader does not have a length, was"
                f" {args.max_steps}"
            )

        if DebugOption.UNDERFLOW_OVERFLOW in self.args.debug:
            if self.args.n_gpu > 1:
                # nn.DataParallel(model) replicates the model, creating new variables and module
                # references registered here no longer work on other gpus, breaking the module
                raise ValueError(
                    "Currently --debug underflow_overflow is not supported under DP. Please use DDP"
                    " (torch.distributed.launch)."
                )
            else:
                debug_overflow = DebugUnderflowOverflow(self.model)  # noqa

        delay_optimizer_creation = (
                self.sharded_ddp is not None
                and self.sharded_ddp != ShardedDDPOption.SIMPLE
                or is_sagemaker_mp_enabled()
                or self.fsdp is not None
        )

        if args.deepspeed:
            deepspeed_engine, optimizer, lr_scheduler = deepspeed_init(
                self, num_training_steps=max_steps, resume_from_checkpoint=resume_from_checkpoint
            )
            self.model = deepspeed_engine.module
            self.model_wrapped = deepspeed_engine
            self.deepspeed = deepspeed_engine
            self.optimizer = optimizer
            self.lr_scheduler = lr_scheduler

        elif not delay_optimizer_creation:
            self.create_optimizer_and_scheduler(num_training_steps=max_steps)

        self.state = TrainerState()
        self.state.is_hyper_param_search = trial is not None

        # Activate gradient checkpointing if needed
        if args.gradient_checkpointing:
            self.model.gradient_checkpointing_enable()

        model = self._wrap_model(self.model_wrapped)

        if is_sagemaker_mp_enabled() and resume_from_checkpoint is not None:
            self._load_from_checkpoint(resume_from_checkpoint, model)

        # for the rest of this function `model` is the outside model, whether it was wrapped or not
        if model is not self.model:
            self.model_wrapped = model

        if delay_optimizer_creation:
            self.create_optimizer_and_scheduler(num_training_steps=max_steps)

        # Check if saved optimizer or scheduler states exist
        # self._load_optimizer_and_scheduler(resume_from_checkpoint)

        # important: at this point:
        # self.model         is the Transformers Model
        # self.model_wrapped is DDP(Transformers Model), Deepspeed(Transformers Model), etc.

        # Train!
        logger.info("***** Running training *****")
        logger.info(f"  Num examples = {num_examples}")
        logger.info(f"  Num Epochs = {num_train_epochs}")
        logger.info(f"  Instantaneous batch size per device = {args.per_device_train_batch_size}")
        logger.info(f"  Total train batch size (w. parallel, distributed & accumulation) = {total_train_batch_size}")
        logger.info(f"  Gradient Accumulation steps = {args.gradient_accumulation_steps}")
        logger.info(f"  Total optimization steps = {max_steps}")
        logger.info(
            f"  Number of trainable parameters = {sum(p.numel() for p in model.parameters() if p.requires_grad)}"
        )

        self.state.epoch = 0
        start_time = time.time()
        epochs_trained = 0
        steps_trained_in_current_epoch = 0
        steps_trained_progress_bar = None

        # Check if continuing training from a checkpoint
        if resume_from_checkpoint is not None and os.path.isfile(
                os.path.join(resume_from_checkpoint, TRAINER_STATE_NAME)
        ):
            self.state = TrainerState.load_from_json(os.path.join(resume_from_checkpoint, TRAINER_STATE_NAME))
            epochs_trained = self.state.global_step // num_update_steps_per_epoch
            if not args.ignore_data_skip:
                steps_trained_in_current_epoch = self.state.global_step % (num_update_steps_per_epoch)
                steps_trained_in_current_epoch *= args.gradient_accumulation_steps
            else:
                steps_trained_in_current_epoch = 0

            logger.info("  Continuing training from checkpoint, will skip to saved global_step")
            logger.info(f"  Continuing training from epoch {epochs_trained}")
            logger.info(f"  Continuing training from global step {self.state.global_step}")
            if not args.ignore_data_skip:
                logger.info(
                    f"  Will skip the first {epochs_trained} epochs then the first {steps_trained_in_current_epoch} "
                    "batches in the first epoch. If this takes a lot of time, you can add the `--ignore_data_skip` "
                    "flag to your launch command, but you will resume the training on data already seen by your model."
                )
                if self.is_local_process_zero() and not args.disable_tqdm:
                    steps_trained_progress_bar = tqdm(total=steps_trained_in_current_epoch)
                    steps_trained_progress_bar.set_description("Skipping the first batches")

        # Update the references
        self.callback_handler.model = self.model
        self.callback_handler.optimizer = self.optimizer
        self.callback_handler.lr_scheduler = self.lr_scheduler
        if args.trainer == 'zo':
            lr_lambda = lambda step: 1#(1 - self.state.global_step / (2 * self.args.max_steps))
            self.lr_scheduler = LambdaLR(self.optimizer, lr_lambda)
        elif args.trainer == 'subzero_sgd':
            lr_lambda = lambda step: 1#(1 - self.state.global_step / self.args.max_steps)
            self.lr_scheduler = LambdaLR(self.optimizer, lr_lambda)

      


        self.callback_handler.train_dataloader = train_dataloader
        if self.hp_name is not None and self._trial is not None:
            # use self._trial because the SigOpt/Optuna hpo only call `_hp_search_setup(trial)` instead of passing trial
            # parameter to Train when using DDP.
            self.state.trial_name = self.hp_name(self._trial)
        if trial is not None:
            assignments = trial.assignments if self.hp_search_backend == HPSearchBackend.SIGOPT else trial
            self.state.trial_params = hp_params(assignments)
        else:
            self.state.trial_params = None
        # This should be the same if the state has been saved but in case the training arguments changed, it's safer
        # to set this after the load.
        self.state.max_steps = max_steps
        self.state.num_train_epochs = num_train_epochs
        self.state.is_local_process_zero = self.is_local_process_zero()
        self.state.is_world_process_zero = self.is_world_process_zero()

        # tr_loss is a tensor to avoid synchronization of TPUs through .item()
        tr_loss = torch.tensor(0.0).to(args.device)
        # _total_loss_scalar is updated everytime .item() has to be called on tr_loss and stores the sum of all losses
        self._total_loss_scalar = 0.0
        self._globalstep_last_logged = self.state.global_step


        model.zero_grad()

        self.control = self.callback_handler.on_train_begin(args, self.state, self.control)

        # Skip the first epochs_trained epochs to get the random state of the dataloader at the right point.
        if not args.ignore_data_skip:
            for epoch in range(epochs_trained):
                is_random_sampler = hasattr(train_dataloader, "sampler") and isinstance(
                    train_dataloader.sampler, RandomSampler
                )
                if is_torch_less_than_1_11 or not is_random_sampler:
                    # We just need to begin an iteration to create the randomization of the sampler.
                    # That was before PyTorch 1.11 however...
                    for _ in train_dataloader:
                        break
                else:
                    # Otherwise we need to call the whooooole sampler cause there is some random operation added
                    # AT THE VERY END!
                    _ = list(train_dataloader.sampler)

        # What parameters to optimize
        self.named_parameters_to_optim = []
        self.named_parameters_to_optim_copy = []
        self.original_params = []
        # self.delta = []
        # self.paramc = []


        for name, param in model.named_parameters():
            if param.requires_grad:
                self.named_parameters_to_optim.append((name, param))
              

        # DiZO added: exclude the layers do not need projection
        if self.named_parameters_to_optim[0][0] != 'model.decoder.embed_tokens.weight':
            self.exclude_list = [each for each in list(self.model.state_dict().keys()) if 'lora' not in each]
        else:
            self.exclude_list = ['model.decoder.embed_tokens.weight'] + [name for name, _ in
                                                                         self.named_parameters_to_optim if
                                                                         'self_attn.v_proj.weight' not in name and 'self_attn.k_proj.weight' not in name]
            self.named_parameters_to_optim = self.named_parameters_to_optim[1:]

        #self.named_parameters_to_optim_copy = [(name, param.clone()) for name, param in self.named_parameters_to_optim]






        # DiZO added: remove the unnecessary parameters to cpu for memory saving
        if args.enhanced in ['zo', 'fo']:
            self.base_model = copy.deepcopy(self.model)
            for name, param in self.base_model.named_parameters():
                if name in self.exclude_list:
                    param.data = param.data.to('cpu')
            self.dizo_trainer = dizo_trainer(self.base_model, train_dataloader, 'l2norm', 0.1, 10, self.exclude_list)

        else:
            args.enhanced = None

        self.loss_list = []
        self.random_vector = {}

        self.accuracy = []







        for epoch in range(epochs_trained, num_train_epochs):

            if isinstance(train_dataloader, DataLoader) and isinstance(train_dataloader.sampler, DistributedSampler):
                train_dataloader.sampler.set_epoch(epoch)
            elif hasattr(train_dataloader, "dataset") and isinstance(train_dataloader.dataset, IterableDatasetShard):
                train_dataloader.dataset.set_epoch(epoch)

            if is_torch_tpu_available():
                parallel_loader = pl.ParallelLoader(train_dataloader, [args.device]).per_device_loader(args.device)
                epoch_iterator = parallel_loader
            else:
                epoch_iterator = train_dataloader





            zo_learning_rate = zo_lr_scheduler(self.args.learning_rate, 'constant', 0, 0, self.state.global_step, int(num_train_epochs))
            Hessian_smooth = Hessian_smooth_scheduler('constant1e-8', self.state.global_step, int(num_train_epochs))




            # Reset the past mems state at the beginning of each epoch if necessary.
            if args.past_index >= 0:
                self._past = None

            steps_in_epoch = (
                len(epoch_iterator)
                if len_dataloader is not None
                else args.max_steps * args.gradient_accumulation_steps
            )
            self.control = self.callback_handler.on_epoch_begin(args, self.state, self.control)

            if epoch == epochs_trained and resume_from_checkpoint is not None and steps_trained_in_current_epoch == 0:
                self._load_rng_state(resume_from_checkpoint)


            for step, inputs in enumerate(epoch_iterator):

                for i in range(torch.cuda.device_count()):
                    torch.cuda.reset_peak_memory_stats(i)


                # Skip past any already trained steps if resuming training
                if steps_trained_in_current_epoch > 0:
                    steps_trained_in_current_epoch -= 1
                    if steps_trained_progress_bar is not None:
                        steps_trained_progress_bar.update(1)
                    if steps_trained_in_current_epoch == 0:
                        self._load_rng_state(resume_from_checkpoint)
                    continue
                elif steps_trained_progress_bar is not None:
                    steps_trained_progress_bar.close()
                    steps_trained_progress_bar = None

                if step % args.gradient_accumulation_steps == 0:
                    self.control = self.callback_handler.on_step_begin(args, self.state, self.control)

                # MeZO added: estimate gradient
                if args.trainer == "zo":






                    tr_loss_step = self.zo_step(model, inputs)
                    #tr_loss_step = self.zo_Hessian_step_update(model, inputs, zo_learning_rate, Hessian_smooth)
                elif args.trainer in ["subzero_sgd"]:
                        

                    tr_loss_step = self.zo_subspace_step(model, inputs)            

                
 

                else:
                    if (
                            ((step + 1) % args.gradient_accumulation_steps != 0)
                            and args.local_rank != -1
                            and args._no_sync_in_gradient_accumulation
                    ):
                        # Avoid unnecessary DDP synchronization since there will be no backward pass on this example.
                        with model.no_sync():
                            tr_loss_step = self.forward_wrap_with_option_len(model, **inputs, return_dict=True).loss
                            # tr_loss_step = self.training_step(model, inputs)
                    else:
                        inputs = self._prepare_inputs(inputs)
                        tr_loss_step = self.forward_wrap_with_option_len(model, **inputs, return_dict=True).loss
                        # tr_loss_step = self.training_step(model, inputs)

                if (
                        args.logging_nan_inf_filter
                        and not is_torch_tpu_available()
                        and (torch.isnan(tr_loss_step) or torch.isinf(tr_loss_step))
                ):
                    # if loss is nan or inf simply add the average of previous logged losses
                    tr_loss += tr_loss / (1 + self.state.global_step - self._globalstep_last_logged)
                else:
                    tr_loss += tr_loss_step

                self.current_flos += float(self.floating_point_ops(inputs))

                # Optimizer step for deepspeed must be called on every step regardless of the value of gradient_accumulation_steps
                if self.deepspeed:
                    self.deepspeed.step()

                if (step + 1) % args.gradient_accumulation_steps == 0 or (
                        # last step in epoch but step is always smaller than gradient_accumulation_steps
                        steps_in_epoch <= args.gradient_accumulation_steps
                        and (step + 1) == steps_in_epoch
                ):
                    # MeZO added: update model with the estimated gradient
                    if args.trainer == "zo":
                        #pass









                        self.zo_update(args, model)
                    elif args.trainer == "subzero_sgd":
                        self.zo_subspace_update(model)





                    else:
                        # Gradient clipping
                        if args.max_grad_norm is not None and args.max_grad_norm > 0 and not self.deepspeed:
                            # deepspeed does its own clipping

                            if self.do_grad_scaling:
                                # Reduce gradients first for XLA
                                if is_torch_tpu_available():
                                    gradients = xm._fetch_gradients(self.optimizer)
                                    xm.all_reduce("sum", gradients, scale=1.0 / xm.xrt_world_size())
                                # AMP: gradients need unscaling
                                self.scaler.unscale_(self.optimizer)

                            if is_sagemaker_mp_enabled() and args.fp16:
                                self.optimizer.clip_master_grads(args.max_grad_norm)
                            elif hasattr(self.optimizer, "clip_grad_norm"):
                                # Some optimizers (like the sharded optimizer) have a specific way to do gradient clipping
                                self.optimizer.clip_grad_norm(args.max_grad_norm)
                            elif hasattr(model, "clip_grad_norm_"):
                                # Some models (like FullyShardedDDP) have a specific way to do gradient clipping
                                model.clip_grad_norm_(args.max_grad_norm)
                            else:
                                # Revert to normal clipping otherwise, handling Apex or full precision
                                nn.utils.clip_grad_norm_(
                                    amp.master_params(self.optimizer) if self.use_apex else model.parameters(),
                                    args.max_grad_norm,
                                )

                        # Optimizer step
                        optimizer_was_run = True
                        if self.deepspeed:
                            pass  # called outside the loop
                        elif is_torch_tpu_available():
                            if self.do_grad_scaling:
                                self.scaler.step(self.optimizer)
                                self.scaler.update()
                            else:
                                xm.optimizer_step(self.optimizer)
                        elif self.do_grad_scaling:
                            scale_before = self.scaler.get_scale()
                            self.scaler.step(self.optimizer)
                            self.scaler.update()
                            scale_after = self.scaler.get_scale()
                            optimizer_was_run = scale_before <= scale_after
                        else:
                            self.optimizer.step()

                        if optimizer_was_run and not self.deepspeed:
                            self.lr_scheduler.step()
                        model.zero_grad()

                    self.state.global_step += 1
                    self.beta_k = 1 + self.state.global_step/6
                    
                    # t = self.state.global_step/2*self.state.max_steps
                    # self.args.zo_eps = 0.01 * (1-t)
                    self.dap_delta = (1-self.state.global_step/self.state.max_steps)**0
                    #print(self.beta_k)
                    self.state.epoch = epoch + (step + 1) / steps_in_epoch
                    self.control = self.callback_handler.on_step_end(args, self.state, self.control)







                    for i in range(torch.cuda.device_count()):
                        peak_mem_step = torch.cuda.max_memory_allocated(i) / (1024 ** 3)
                        logger.info(f"[GPU {i}] Step {self.state.global_step} Peak memory: {peak_mem_step:.2f} GB")
                        #wandb.log({f"gpu_{i}_step_peak_mem_gb": peak_mem_step, "global_step": self.state.global_step})
                        torch.cuda.reset_peak_memory_stats(i)







                    log_step = 50 if args.trainer == 'zo' or args.trainer == 'subzero_sgd' else 10
                    if self.state.global_step % log_step == 0:
                        avg_loss = tr_loss / (self.state.global_step - self._globalstep_last_logged + 1)
                        logger.info(
                            {'loss': round(tr_loss_step.item(), 4), 'epoch': epoch, 'lr': self._get_learning_rate()})
                        
                        wandb.log({
        "train_loss": avg_loss.item(),
        "global_step": self.state.global_step, 
        "epoch": epoch,
        "learning_rate": self._get_learning_rate(),
        
    }, commit=True)


                    self.loss_list.append(tr_loss_step.item())
                    self.args.eval_steps = 100

                    if self.state.global_step % self.args.eval_steps == 0:

                        path = 'loss_acc/{}_{}_{}_enhanced_{}'.format(self.args.task_name, args.trainer, 'lora' if args.lora else 'ft', args.enhanced)
                        if not os.path.exists(path):
                            os.makedirs(path)
                        np.save(path + '/' + 'loss_list_seed_{}.npy'.format(args.seed), self.loss_list)
                        predictions = []
                        for eval_sample in self.eval_dataset:
                            predictions.append(
                                self.one_step_pred([], eval_sample, verbose=False)
                            )
                        metric_name = getattr(self.task, "metric_name", "accuracy")
                        metrics = {metric_name: calculate_metric(predictions, metric_name)}
                        metrics["global_step"] = self.state.global_step
                        logger.info(f"Eval results: {metrics}")
                        self.accuracy.append(metrics[metric_name])

                        wandb.log({"Eval accuracy": metrics[metric_name],"global_step": self.state.global_step})

                        if hasattr(self, "eval_loss_list") and len(self.eval_loss_list) >= 50:
                            avg_eval_loss = np.mean(self.eval_loss_list[-50:])
                            logger.info(f"Average eval loss over last 50 eval samples: {avg_eval_loss:.4f}")
                            wandb.log({
                                "eval_loss_50_avg": avg_eval_loss,
                                "global_step": self.state.global_step
                            })

                        np.save(path + '/' + 'accuracy_seed_{}.npy'.format(args.seed), self.accuracy)

                        if metrics[metric_name] >= self.objective:
                            logger.info("Best dev result: {}".format(metrics[metric_name]))
                            self.objective = metrics[metric_name]
                            # self.save_model(self.args.output_dir)

                            # Now we save this to (CPU) memory instead of disk <-- much faster
                            self.best_model_ckpt = {k: v.detach().cpu() for k, v in model.state_dict().items()}
                else:
                    self.control = self.callback_handler.on_substep_end(args, self.state, self.control)

                if self.control.should_epoch_stop or self.control.should_training_stop:
                    break

            if step < 0:
                logger.warning(
                    "There seems to be not a single sample in your epoch_iterator, stopping training at step"
                    f" {self.state.global_step}! This is expected if you're using an IterableDataset and set"
                    f" num_steps ({max_steps}) higher than the number of available samples."
                )
                self.control.should_training_stop = True

            self.control = self.callback_handler.on_epoch_end(args, self.state, self.control)

            if DebugOption.TPU_METRICS_DEBUG in self.args.debug:
                if is_torch_tpu_available():
                    # tpu-comment: Logging debug metrics for PyTorch/XLA (compile, execute times, ops, etc.)
                    xm.master_print(met.metrics_report())
                else:
                    logger.warning(
                        "You enabled PyTorch/XLA debug metrics but you don't have a TPU "
                        "configured. Check your training configuration if this is unexpected."
                    )
            if self.control.should_training_stop:
                break

        if args.past_index and hasattr(self, "_past"):
            # Clean the state at the end of training
            delattr(self, "_past")

        logger.info("\n\nTraining completed. Do not forget to share your model on huggingface.co/models =)\n\n")
        if args.load_best_model_at_end and self.state.best_model_checkpoint is not None:
            # Wait for everyone to get here so we are sur the model has been saved by process 0.
            if is_torch_tpu_available():
                xm.rendezvous("load_best_model_at_end")
            elif args.local_rank != -1:
                dist.barrier()
            elif is_sagemaker_mp_enabled():
                smp.barrier()

            self._load_best_model()

        # add remaining tr_loss
        self._total_loss_scalar += tr_loss.item()
        train_loss = self._total_loss_scalar / self.state.global_step

        metrics = speed_metrics("train", start_time, num_samples=num_train_samples, num_steps=self.state.max_steps)
        self.store_flos()
        metrics["total_flos"] = self.state.total_flos
        metrics["train_loss"] = train_loss
        

        self.is_in_train = False

        self._memory_tracker.stop_and_update_metrics(metrics)

        self.log(metrics)

        run_dir = self._get_output_dir(trial)
        checkpoints_sorted = self._sorted_checkpoints(use_mtime=False, output_dir=run_dir)

        # Delete the last checkpoint when save_total_limit=1 if it's different from the best checkpoint.
        if self.state.best_model_checkpoint is not None and self.args.save_total_limit == 1:
            for checkpoint in checkpoints_sorted:
                if checkpoint != self.state.best_model_checkpoint:
                    logger.info(f"Deleting older checkpoint [{checkpoint}] due to args.save_total_limit")
                    shutil.rmtree(checkpoint)

        self.control = self.callback_handler.on_train_end(args, self.state, self.control)

        return TrainOutput(self.state.global_step, train_loss, metrics)
#         return super()._inner_training_loop(
#     batch_size=batch_size,
#     args=args,
#     resume_from_checkpoint=resume_from_checkpoint,
#     trial=trial,
#     ignore_keys_for_eval=ignore_keys_for_eval,
# )
    
    

    
    
    def training_step(self, model, inputs):
        loss = super().training_step(model, inputs)  
        wandb.log({"train_loss": loss.item()})  
        return loss













    ############## MeZO ##############


    def zo_perturb_parameters(self, scaling_factor=1, random_seed=None):
        """
        Perturb the parameters with random vector z.
        Input:
        - random_seed: random seed for MeZO in-place perturbation (if it's None, we will use self.zo_random_seed)
        - scaling_factor: theta = theta + scaling_factor * z * eps
        """

        # Set the random seed to ensure that we sample the same z for perturbation/update
        torch.manual_seed(random_seed if random_seed is not None else self.zo_random_seed)


        #for name, param in self.named_parameters_to_optim:
        #for (name, param), (c_name, c_param) in zip(self.named_parameters_to_optim, self.named_parameters_to_optim_copy):
        for name, param in self.named_parameters_to_optim:
            z = torch.normal(mean=0, std=1, size=param.data.size(), device=param.data.device, dtype=param.data.dtype)
            #z = z / torch.norm(z,p=2) * torch.sqrt(torch.tensor(param.data.numel(), dtype=param.data.dtype))
            #k = (2 * torch.rand(1, device=param.data.device).item() - 1) * (1-self.state.global_step/self.state.max_steps)

            # m = torch.norm(z,p=2,dim=0,keepdim=True)
            # m = z / m
            

            # mask_logit = process_mask_logit(c_param.data)  # 确保 1D
            # hidden_dim = mask_logit.shape[0] 
            # covariance = get_anisotropic_covariance(mask_logit)
            # if c_param.data.dim() == 1:
            #     z = torch.normal(mean=0, std=1, size=param.data.size(), device=param.data.device, dtype=param.data.dtype)
            #     z = z / torch.norm(z, p=2)
            # elif c_param.data.dim() == 2:
            #     z = torch.normal(mean=0, std=1, size=param.data.T.size(), device=param.data.device, dtype=param.data.dtype)
            #     z = z / torch.norm(z, p=2,dim=0)
            # L = torch.linalg.cholesky(covariance)
            # perturbations = torch.matmul(L, z)
            # z = perturbations.T

            

            # c_param.data = param.data + st * d_param
            param.data = param.data + scaling_factor * z * 0.001

            # param.data = c_param.data / self.beta_k + (1 - 1 / self.beta_k) * param.data
            # param.data = param.data + scaling_factor * z * self.args.zo_eps * r 
            # if self.zo_random_seed is not None:
            #     self.random_vector[name] = z
        
    
    def zo_subspace_perturb_parameters(self, scaling_factor=1):
        torch.manual_seed(self.zo_random_seed)
        for n, p in self.named_parameters_to_optim:
            info = self.p_state[n]
            if info["U"] is None:           
         
                # G = info["G"]  
                # C0 = torch.randn_like(p) 
                # #C0 = C0 / torch.norm(C0,p=2)  * torch.sqrt(torch.tensor(p.data.numel(), dtype=p.data.dtype))
                # C0 = C0 * ((self.dap_delta)**0.5) 
                # #C0.div_(torch.norm(C0, p='fro').clamp(min=1e-12))
                # inner = (G * C0).sum()
                # gnorm = G.norm()
                # xi    = torch.randint(0,2,(),device=p.device)*2 - 1
                # alpha     = (inner - xi * ((self.dap_delta)**0.5) * gnorm) / (gnorm*gnorm + 1e-12)
                # C     = C0 - alpha * G
                # p.add_(scaling_factor * C * self.args.zo_eps)
                z = torch.normal(0., 1., size=p.data.size(), device=p.data.device, dtype=p.data.dtype)
                p.add_(scaling_factor * z * self.args.zo_eps)
            else:
                U, S_diag, Vt = info["U"], info["S"], info["Vt"]
                r  = U.shape[1]
             
                C0  = torch.randn(r, r, device=p.device, dtype=p.dtype)
                #C0 = C0 / torch.norm(C0,p=2)  * torch.sqrt(torch.tensor(C0.numel(), dtype=p.data.dtype))
                C0 = C0 * ((self.dap_delta)**0.5) 
                #C0.div_(torch.norm(C0, p='fro').clamp(min=1e-12))
                # -------- 2) DAP 
                Sr = torch.diag(S_diag)
                inner = (Sr * C0).sum()
                gnorm = S_diag.square().sum().sqrt()
                xi    = (torch.randint(0, 2, (), device=p.device, dtype=p.dtype) * 2 - 1)  # ±1
                alpha = (inner - xi * ((self.dap_delta)**0.5) * gnorm) / (gnorm**2 + 1e-12)
                C     = C0 - alpha * Sr
                #print(U.shape,C.shape,Vt.shape)
             
                V = U @ C @ Vt.T
                
                p.add_(scaling_factor * V * self.args.zo_eps)
    



    @staticmethod
    def forward_wrap_with_option_len(self, input_ids=None, labels=None, option_len=None, num_options=None,
                                     return_dict=None, **kwargs):
        """
        This is to replace the original forward function of Transformer models to enable:
        (1) Partial target sequence: loss will only be calculated on part of the sequence
        (2) Classification-style training: a classification loss (CE) will be calculated over several options
        Input:
        - input_ids, labels: same as the original forward function
        - option_len: a list of int indicating the option lengths, and loss will be calculated only on the
          last option_len tokens
        - num_options: a list of int indicating the number of options for each example (this will be #label
          words for classification tasks and #choices for multiple choice tasks), and a classification loss
          will be calculated.
        """
        with torch.no_grad():
            outputs = self.forward(input_ids=input_ids, **kwargs)

        if labels is None:
            return outputs
        logits = outputs.logits

        # Shift so that tokens < n predict n
        shift_logits = logits[..., :-1, :].contiguous()
        # Here we use input_ids (which should always = labels) bc sometimes labels are correct candidate IDs
        shift_labels = torch.clone(input_ids)[..., 1:].contiguous()
        shift_labels[shift_labels == self.config.pad_token_id] = -100

        # Apply option len (do not calculate loss on the non-option part)
        if option_len is not None:
            for _i, _len in enumerate(option_len):
                shift_labels[_i, :-_len] = -100

        # Calculate the loss
        loss_fct = CrossEntropyLoss(ignore_index=-100)
        if num_options is not None:
            # Train as a classification tasks
            log_probs = F.log_softmax(shift_logits, dim=-1)
            mask = shift_labels != -100  # Option part
            shift_labels[~mask] = 0  # So that it doesn't mess up with indexing

            selected_log_probs = torch.gather(log_probs, dim=-1, index=shift_labels.unsqueeze(-1)).squeeze(
                -1)  # (bsz x num_options, len)
            selected_log_probs = (selected_log_probs * mask).sum(-1) / mask.sum(-1)  # (bsz x num_options)

            if any([x != num_options[0] for x in num_options]):
                # Multi choice tasks with different number of options
                loss = 0
                start_id = 0
                count = 0
                while start_id < len(num_options):
                    end_id = start_id + num_options[start_id]
                    _logits = selected_log_probs[start_id:end_id].unsqueeze(0)  # (1, num_options)
                    _labels = labels[start_id:end_id][0].unsqueeze(0)  # (1)
                    loss = loss_fct(_logits, _labels) + loss
                    count += 1
                    start_id = end_id
                loss = loss / count
            else:
                num_options = num_options[0]
                selected_log_probs = selected_log_probs.view(-1, num_options)  # (bsz, num_options)
                labels = labels.view(-1, num_options)[:, 0]  # Labels repeat so we only take the first one
                loss = loss_fct(selected_log_probs, labels)
        else:
            loss = loss_fct(shift_logits.view(-1, self.config.vocab_size), shift_labels.view(-1))

        if not return_dict:
            output = (logits,) + outputs[1:]
            return (loss,) + output if loss is not None else output

        return CausalLMOutputWithPast(
            loss=loss,
            # logits=logits,
            # past_key_values=outputs.past_key_values,
            # hidden_states=outputs.hidden_states,
            # attentions=outputs.attentions,
        )

    def zo_forward(self, model, inputs):
        """
        Get (no gradient) loss from the model. Dropout is turned off too.
        """
        model.eval()
        if self.args.non_diff:
            # Non-differentiable objective (may require autoregressive generation)
            return self.zo_forward_nondiff(model, inputs)

        with torch.inference_mode():
            inputs = self._prepare_inputs(inputs)
            with self.compute_loss_context_manager():
                with torch.no_grad():
                    # loss = self.compute_loss(model, inputs)
                    loss = self.forward_wrap_with_option_len(model, **inputs, return_dict=True).loss
            if self.args.n_gpu > 1:
                # Warning: this is copied from the original Huggingface Trainer. Untested.
                loss = loss.mean()  # mean() to average on multi-gpu parallel training
        return loss.detach()



    
    # def zo_forward_nondiff(self, model, inputs):
    #     """
    #     Get (no gradient) non-diffiable loss from the model.
    #     """
    #     model.eval()
    #     assert self.args.task_name == "SQuAD", "Non differentiable objective only supports SQuAD for now."

    #     with torch.inference_mode():
    #         inputs = self._prepare_inputs(inputs)
    #         args = self.args


    #         if self.tokenizer.pad_token_id is None:
    #             self.tokenizer.pad_token = self.tokenizer.unk_token

  
    #         if "attention_mask" not in inputs:
    #             inputs["attention_mask"] = (inputs["input_ids"] != self.tokenizer.pad_token_id).long()

    #         outputs = self.model.generate(
    #             input_ids=inputs["input_ids"],
    #             attention_mask=inputs["attention_mask"],
    #             do_sample=args.sampling,
    #             temperature=args.temperature,
    #             num_beams=args.num_beams,
    #             top_p=args.top_p,
    #             top_k=args.top_k,
    #             max_new_tokens=min(args.max_new_tokens, args.max_length - inputs["input_ids"].size(1)),
    #             num_return_sequences=1,
    #             pad_token_id=self.tokenizer.pad_token_id,
    #             eos_token_id=[
    #                 self.tokenizer.encode(args.eos_token, add_special_tokens=False)[-1],
    #                 self.tokenizer.eos_token_id,
    #             ],
    #         )

    #         output_text = []
    #         for i in range(len(outputs)):
    #             output_text.append(
    #                 self.tokenizer.decode(outputs[i][inputs["input_ids"].size(1):], skip_special_tokens=True).strip())
    #         f1s = [f1(output_text[i], inputs['gold'][i]) for i in range(len(output_text))]

    #     return -torch.tensor(np.mean(f1s), dtype=torch.float32)


    def zo_forward_nondiff(self, model, inputs):
        """
        Get (no gradient) non-diffiable loss from the model.
        """
        model.eval()
        assert self.args.task_name == "SQuAD", "Non differentiable objective only supports SQuAD for now."

        with torch.inference_mode():
            inputs = self._prepare_inputs(inputs)
            args = self.args
            outputs = self.model.generate(
                inputs["input_ids"], do_sample=args.sampling, temperature=args.temperature,
                num_beams=args.num_beams, top_p=args.top_p, top_k=args.top_k,
                max_new_tokens=min(args.max_new_tokens, args.max_length - inputs["input_ids"].size(1)),
                num_return_sequences=1,
                eos_token_id=[self.tokenizer.encode(args.eos_token, add_special_tokens=False)[-1],
                              self.tokenizer.eos_token_id],
            )
            output_text = []
            for i in range(len(outputs)):
                output_text.append(
                    self.tokenizer.decode(outputs[i][inputs["input_ids"].size(1):], skip_special_tokens=True).strip())
            f1s = [f1(output_text[i], inputs['gold'][i]) for i in range(len(output_text))]

        return -torch.tensor(np.mean(f1s), dtype=torch.float32)

    def zo_step(self, model, inputs):
        """
        Estimate gradient by MeZO. Return the loss from f(theta + z)
        """
        args = self.args

        # Sample the random seed for sampling z
        self.zo_random_seed = np.random.randint(1000000000)

        # self.kr = (2*torch.rand(1).item()-1) / (math.ceil((self.state.global_step+1) / 500)+1)
        # self.st = torch.rand(1).item()

        # m = torch.normal(mean=0, std=0.0001, size=(1,)).item()
        # n = torch.normal(mean=0, std=0.0001, size=(1,)).item()


        #self.savec = self.named_parameters_to_optim_copy

        # First function evaluation
        self.zo_perturb_parameters(scaling_factor=1)
        loss1 = self.zo_forward(model, inputs) 



        #self.named_parameters_to_optim_copy = self.savec

        # Second function evaluation
        self.zo_perturb_parameters(scaling_factor=-2)   ###
        loss2 = self.zo_forward(model, inputs)



        self.projected_grad = ((loss1 - loss2) / (2 * self.args.zo_eps)).item()

        # No gradient accumulation support
        assert self.args.gradient_accumulation_steps == 1

        # Reset model back to its parameters at start of step
        self.zo_perturb_parameters(scaling_factor=1)


        #self.named_parameters_to_optim_copy = self.savec
        
        

        assert self.args.gradient_accumulation_steps == 1  


        return loss1
    

    @torch.no_grad()
    def zo_subspace_step(self, model, inputs):
   
        args = self.args

        # --------------------------------------------------
     
        # --------------------------------------------------
        new_window = (self.state.global_step == getattr(self, "subspace_step0", 0))

        if new_window:
  
            self.G_cache = {n: torch.zeros_like(p) for n, p in self.named_parameters_to_optim}

         -
            rhos = []
            for _ in range(self.k_probe):
                self.zo_random_seed = np.random.randint(1e9)

                # +ε
                self.zo_perturb_parameters(scaling_factor=1)
                loss_p = self.zo_forward(model, inputs)

                # −ε
                self.zo_perturb_parameters(scaling_factor=-2)
                loss_m = self.zo_forward(model, inputs)

        
                self.zo_perturb_parameters(scaling_factor=1)

                rho = (loss_p - loss_m) / (2 * 0.01)
                rhos.append(loss_p - loss_m)
                



         
                torch.manual_seed(self.zo_random_seed)
                for n, p in self.named_parameters_to_optim:
                    z = torch.normal(0, 1, size=p.shape, device=p.device, dtype=p.dtype)
                    #z = z / torch.norm(z,p=2) * torch.sqrt(torch.tensor(p.data.numel(), dtype=p.data.dtype))
                    k = (2 * torch.rand(1, device=p.data.device).item() - 1)* (1-self.state.global_step/self.state.max_steps)
                    ker = kernel_function(k)
                    #z.div_(torch.norm(z, p='fro').clamp(min=1e-12))
                    rho_t = torch.tensor(rho*ker, device=p.device, dtype=p.dtype)
                    self.G_cache[n].add_(rho_t * z / self.k_probe)
            
               
            rhos_tensor = torch.tensor(rhos, device=next(model.parameters()).device)
            sigma_loss = rhos_tensor.std(unbiased=False).item() 
            # d_total = sum(p.numel() for _, p in self.named_parameters_to_optim)
            # CC = math.sqrt(d_total)
            print(sigma_loss)
            self.adaptive_alpha = 1 / (sigma_loss + 1e-12)
            


            self.p_state = {}
            for n, p in self.named_parameters_to_optim:
                G = self.G_cache[n]
                if G.ndim == 2:                                
                    # M = torch.randn((G.shape[1], self.rank_r), device=G.device, dtype=G.dtype)
                    # U, S, Vt = torch.svd_lowrank(G, q=self.rank_r, M=M)
                    G_fp32 = G.to(torch.float32)

               
                    U32, S32, Vt32 = torch.svd_lowrank(G_fp32, q=self.rank_r)
                    #print(U32.shape, S32.shape, Vt32.shape)

                 
                    U  = U32.to(G.dtype).to(G.device)
                    S  = S32.to(G.dtype).to(G.device)
                    Vt = Vt32.to(G.dtype).to(G.device)
                    
                    self.p_state[n] = {"U": U.contiguous(),
                                    "S": S[:self.rank_r].contiguous(),
                                    "Vt": Vt.contiguous()}
                else:                                         
                    self.p_state[n] = {"U": None, "G": G.clone()}
            del G_fp32, U32, S32, Vt32
            del self.G_cache
        # --------------------------------------------------
       
        # --------------------------------------------------
        self.zo_random_seed = np.random.randint(1e9)

  
        self.zo_subspace_perturb_parameters(scaling_factor=1)
        loss_plus = self.zo_forward(model, inputs)

        # −ε
        self.zo_subspace_perturb_parameters(scaling_factor=-2)
        loss_minus = self.zo_forward(model, inputs)

  
        self.zo_subspace_perturb_parameters(scaling_factor=1)

        # --------------------------------------------------
      
        # --------------------------------------------------
        self.projected_grad = ((loss_plus - loss_minus) /
                            (2 * self.args.zo_eps)).item()

        # --------------------------------------------------

        # --------------------------------------------------
        if (self.state.global_step - self.subspace_step0 + 1) >= self.window:
            self.subspace_step0 += self.window   

        return loss_plus

    def zo_update(self, args, model):
        """
        Update the parameters with the estimated gradients.
        """

        # Reset the random seed for sampling zs
        torch.manual_seed(self.zo_random_seed)
        #K_r = kernel_function(self.kr)
        
        

        #for name, param in self.named_parameters_to_optim:
        #for (name, param), (c_name, c_param) in zip(self.named_parameters_to_optim, self.named_parameters_to_optim_copy):      ######
        for name, param in self.named_parameters_to_optim:
            # Resample z
            
            z = torch.normal(mean=0, std=1, size=param.data.size(), device=param.data.device, dtype=param.data.dtype)
            # m = torch.norm(z,p=2,dim=0,keepdim=True)
            # m = z / m
            

            # mask_logit = process_mask_logit(c_param.data)  
            # hidden_dim = mask_logit.shape[0] 
            # covariance = get_anisotropic_covariance(mask_logit)
            # if c_param.data.dim() == 1:
            #     z = torch.normal(mean=0, std=1, size=param.data.size(), device=param.data.device, dtype=param.data.dtype)
            #     z = z / torch.norm(z, p=2)
            # elif c_param.data.dim() == 2:
            #     z = torch.normal(mean=0, std=1, size=param.data.T.size(), device=param.data.device, dtype=param.data.dtype)
            #     z = z / torch.norm(z, p=2,dim=0)
            # L = torch.linalg.cholesky(covariance)
            # perturbations = torch.matmul(L, z)
            # z = perturbations.T
            # Sigma = get_anisotropic_covariance(c_param.data)
            # L = torch.linalg.cholesky(Sigma)
            # if c_param.data.dim() == 1:
            #     #z = torch.normal(mean=0, std=1, size=param.data.size(), device=param.data.device, dtype=param.data.dtype)
            #     perturbation_corrected = torch.cholesky_solve(z.unsqueeze(-1), L).squeeze(-1) 
            # if c_param.data.dim() == 2:
            #     #z = torch.normal(mean=0, std=1, size=param.data.size(), device=param.data.device, dtype=param.data.dtype)
            #     perturbation_corrected = torch.cholesky_solve(z.T, L)
            # z = perturbation_corrected
            #print(perturbation_corrected.shape, c_param.data.shape)



            param.data = param.data - self._get_learning_rate() * (self.projected_grad * z)

            # c_param.data = c_param.data - self._get_learning_rate() * (self.projected_grad * z  * K_r)
            # param.data = c_param.data / self.beta_k + (1 - 1 / self.beta_k) * param.data
            
            # param.data = param.data + d_param
            # c_param.data = param.data + self.st * d_param
            # d_param = d_param - self._get_learning_rate() * (self.projected_grad * z )
            # midparam = midparam - self._get_learning_rate() * (self.projected_grad * z )
            # param.data = midparam.data / self.beta_k + (1 - 1 / self.beta_k) * param.data


        # DiZO added
        # if (self.state.global_step + 1) % 50 == 0 and args.enhanced:
        #     if args.enhanced == 'zo':
        #         self.dizo_trainer.dizo_zo_iters(model, base_model=self.base_model)
        #     else:
        #         self.dizo_trainer.dizo_iters(model, base_model=self.base_model)

        self.lr_scheduler.step()
    


    def zo_subspace_update(self, model):
        """
        根据 projected_grad 和 与 zo_subspace_step 同一随机种子
        重新采样 z → 设置 param.grad → optimizer.step()
        """
        args = self.args
        torch.manual_seed(self.zo_random_seed)          

        for name, param in self.named_parameters_to_optim:
            info = self.p_state[name]

       
            if info["U"] is None:                     

                # G = info["G"]
             
                # C0 = torch.randn_like(param) 
                # #C0 = C0 / torch.norm(C0,p=2)  * torch.sqrt(torch.tensor(param.data.numel(), dtype=param.data.dtype))
                # C0 = C0 * ((self.dap_delta)**0.5) 
                # #C0.div_(torch.norm(C0, p='fro').clamp(min=1e-12))
                # inner = (G * C0).sum()
                # gnorm = G.norm()
                # xi    = torch.randint(0,2,(),device=param.device)*2 - 1
                # alpha     = (inner - xi * ((self.dap_delta)**0.5) * gnorm) / (gnorm*gnorm + 1e-12)
                # C     = C0 - alpha * G
                # z  = C
                z = torch.normal(0., 1., size=param.data.size(), device=param.data.device, dtype=param.data.dtype)

                
            else:
                U, S_diag, Vt = info["U"], info["S"], info["Vt"]
                r   = U.shape[1]
       
                C0  = torch.randn(r, r, device=param.device, dtype=param.dtype) 
                #C0 = C0 / torch.norm(C0,p=2)   * torch.sqrt(torch.tensor(C0.numel(), dtype=param.data.dtype))
                C0 = C0 * ((self.dap_delta)**0.5) 
                #C0.div_(torch.norm(C0, p='fro').clamp(min=1e-12))
 
                Sr  = torch.diag(S_diag)
                inner = (Sr * C0).sum()
                gnorm = S_diag.square().sum().sqrt()
                xi    = (torch.randint(0, 2, (), device=param.device, dtype=param.dtype) * 2 - 1)   # ±1
                alpha = (inner - xi * ((self.dap_delta) ** 0.5) * gnorm) / (gnorm ** 2 + 1e-12)
                C     = C0 - alpha * Sr
     
                z     = U @ C @ Vt.T




       
            #param.grad = self.projected_grad * z       
            #param.data = param.data -  self.adaptive_alpha * self._get_learning_rate() * self.projected_grad * z
            grad = self.projected_grad * z
            #print(torch.norm(self.projected_grad * z,p=2))
            #grad = min(1,(400.0)/torch.norm(grad,p=2)) * grad
            param.data = param.data -  self._get_learning_rate() * grad
            
     
        #self.optimizer.step()

        # for _, param, *_ in self.named_parameters_to_optim:
  
      
        #     d = param.numel()
        #     r = self.args.zo_eps  
        #     sigma = r / math.sqrt(d)
        #     noise = -torch.randn_like(param) * sigma
        #     param.add_(self.args.learning_rate * noise)
        self.lr_scheduler.step()


        for _, param in self.named_parameters_to_optim:
            param.grad = None
        self.update_steps += 1
        if self.update_steps % 1000 == 0:
            print("model update", self.update_steps)


    ############## Misc overload functions ##############

    def _set_signature_columns_if_needed(self):
        """
        We overload this function for non-differentiable objective training to pass "gold" -- the gold text for the task
        """
        if self._signature_columns is None:
            # Inspect model forward signature to keep only the arguments it accepts.
            signature = inspect.signature(self.model.forward)
            self._signature_columns = list(signature.parameters.keys())
            # Labels may be named label or label_ids, the default data collator handles that.
            self._signature_columns += list(set(["label", "label_ids"] + self.label_names))
            self._signature_columns += ["gold"]

    def save_model(self, output_dir: Optional[str] = None, _internal_call: bool = False):
        """
        We overload this function to fix an FSDP saving bug (before fix, it will likely cause OOM)
        """

        if output_dir is None:
            output_dir = self.args.output_dir

        if is_torch_tpu_available():
            self._save_tpu(output_dir)
        elif is_sagemaker_mp_enabled():
            # Calling the state_dict needs to be done on the wrapped model and on all processes.
            os.makedirs(output_dir, exist_ok=True)
            state_dict = self.model_wrapped.state_dict()
            if self.args.should_save:
                self._save(output_dir, state_dict=state_dict)
            if IS_SAGEMAKER_MP_POST_1_10:
                # 'user_content.pt' indicates model state_dict saved with smp >= 1.10
                Path(os.path.join(output_dir, "user_content.pt")).touch()
        elif (
                ShardedDDPOption.ZERO_DP_2 in self.args.sharded_ddp
                or ShardedDDPOption.ZERO_DP_3 in self.args.sharded_ddp
                or self.fsdp is not None
        ):
            from torch.distributed.fsdp import FullyShardedDataParallel as FSDP, StateDictType, FullStateDictConfig
            full_state_dict_config = FullStateDictConfig(offload_to_cpu=True, rank0_only=True)

            # Fix the FSDP loading bug
            with FSDP.state_dict_type(self.model, StateDictType.FULL_STATE_DICT, full_state_dict_config):
                state_dict = self.model.state_dict()
            # state_dict = self.model.state_dict()

            if self.args.should_save:
                self._save(output_dir, state_dict=state_dict)
        elif self.deepspeed:
            # this takes care of everything as long as we aren't under zero3
            if self.args.should_save:
                self._save(output_dir)

            if is_deepspeed_zero3_enabled():
                # It's too complicated to try to override different places where the weights dump gets
                # saved, so since under zero3 the file is bogus, simply delete it. The user should
                # either user deepspeed checkpoint to resume or to recover full weights use
                # zero_to_fp32.py stored in the checkpoint.
                if self.args.should_save:
                    file = os.path.join(output_dir, WEIGHTS_NAME)
                    if os.path.isfile(file):
                        # logger.info(f"deepspeed zero3: removing {file}, see zero_to_fp32.py to recover weights")
                        os.remove(file)

                # now save the real model if stage3_gather_16bit_weights_on_model_save=True
                # if false it will not be saved.
                # This must be called on all ranks
                if not self.deepspeed.save_16bit_model(output_dir, WEIGHTS_NAME):
                    logger.warning(
                        "deepspeed.save_16bit_model didn't save the model, since"
                        " stage3_gather_16bit_weights_on_model_save=false. Saving the full checkpoint instead, use"
                        " zero_to_fp32.py to recover weights"
                    )
                    self.deepspeed.save_checkpoint(output_dir)

        elif self.args.should_save:
            self._save(output_dir)

        # Push to the Hub when `save_model` is called by the user.
        if self.args.push_to_hub and not _internal_call:
            self.push_to_hub(commit_message="Model save")

    


    # def forward(self, input_ids, option_len=None, generation=False):
    #     """
    #     Given input_ids and the length of the option, return the log-likelihood of each token in the option.
    #     For generation tasks, return the generated text.
    #     This function is only for inference
    #     """
    #     input_ids = torch.tensor([input_ids]).to(self.model.device)

    #     # 设置 pad_token_id 如果没有
    #     if self.tokenizer.pad_token_id is None:
    #         self.tokenizer.pad_token = self.tokenizer.unk_token

    #     attention_mask = (input_ids != self.tokenizer.pad_token_id).long()

    #     if generation:
    #         args = self.args
    #         outputs = self.model.generate(
    #             input_ids=input_ids,
    #             attention_mask=attention_mask,
    #             do_sample=args.sampling,
    #             temperature=args.temperature,
    #             num_beams=args.num_beams,
    #             top_p=args.top_p,
    #             top_k=args.top_k,
    #             max_new_tokens=min(args.max_new_tokens, args.max_length - input_ids.size(1)),
    #             num_return_sequences=1,
    #             pad_token_id=self.tokenizer.pad_token_id,
    #             eos_token_id=[
    #                 self.tokenizer.encode(args.eos_token, add_special_tokens=False)[-1],
    #                 self.tokenizer.eos_token_id,
    #             ],
    #         )
    #         output_text = self.tokenizer.decode(outputs[0][input_ids.size(1):], skip_special_tokens=True).strip()
    #         return output_text
    #     else:
    #         with torch.inference_mode():
    #             self.model.eval()
    #             logits = self.model(input_ids=input_ids, attention_mask=attention_mask).logits
    #         labels = input_ids[0, 1:]
    #         logits = logits[0, :-1]
    #         log_probs = F.log_softmax(logits, dim=-1)

    #         selected_log_probs = log_probs[torch.arange(len(labels)).to(labels.device), labels]
    #         return selected_log_probs[-option_len:]


    def forward(self, input_ids, option_len=None, generation=False):
        """
        Given input_ids and the length of the option, return the log-likelihood of each token in the option.
        For generation tasks, return the generated text.
        This function is only for inference
        """
        input_ids = torch.tensor([input_ids]).to(self.model.device)

        if generation:
            args = self.args
            # Autoregressive generation
            outputs = self.model.generate(
                input_ids, do_sample=args.sampling, temperature=args.temperature,
                num_beams=args.num_beams, top_p=args.top_p, top_k=args.top_k,
                max_new_tokens=min(args.max_new_tokens, args.max_length - input_ids.size(1)),
                num_return_sequences=1,
                eos_token_id=[self.tokenizer.encode(args.eos_token, add_special_tokens=False)[-1],
                              self.tokenizer.eos_token_id],
            )
            # For generation, directly return the text output
            output_text = self.tokenizer.decode(outputs[0][input_ids.size(1):], skip_special_tokens=True).strip()
            return output_text
        else:
            with torch.inference_mode():
                self.model.eval()
                logits = self.model(input_ids=input_ids).logits
            labels = input_ids[0, 1:]
            logits = logits[0, :-1]
            log_probs = F.log_softmax(logits, dim=-1)

            selected_log_probs = log_probs[torch.arange(len(labels)).to(labels.device), labels]
            selected_log_probs = selected_log_probs.cpu().detach()
            # Only return the option (candidate) part
            return selected_log_probs[-option_len:]
        
    # def one_step_pred(self, train_samples, eval_sample, verbose=False):
    #     """
    #     Return the prediction on the eval sample. In ICL, use train_samples as demonstrations.
    #     Supports both generation and classification tasks, and logs eval loss.
    #     """
    #     verbose = verbose or self.args.verbose
    #     if verbose:
    #         logger.info("========= Example =========")
    #         logger.info(f"Candidate: {eval_sample.candidates}")
    #         logger.info(f"Correct candidate: {eval_sample.correct_candidate}")

    #     # Encode prompts
    #     encoded_candidates, option_lens = encode_prompt(
    #         self.task, self.task.get_template(), train_samples, eval_sample, self.tokenizer,
    #         max_length=self.args.max_length,
    #         generation=self.task.generation, max_new_tokens=self.args.max_new_tokens
    #     )

    #     # Calibration prompts
    #     if self.args.sfc or self.args.icl_sfc:
    #         sfc_encoded_candidates, sfc_option_lens = encode_prompt(
    #             self.task, self.task.get_template(), train_samples, eval_sample, self.tokenizer,
    #             max_length=self.args.max_length,
    #             sfc=self.args.sfc, icl_sfc=self.args.icl_sfc,
    #             generation=self.task.generation, max_new_tokens=self.args.max_new_tokens
    #         )

    #     outputs = []

    #     # =============================
    #     # 🔹 Generation task
    #     # =============================
    #     if self.task.generation:
    #         output_text = self.forward(encoded_candidates[0], generation=True)

    #         # ===== Compute eval loss (requires gold) =====
    #         if hasattr(eval_sample, 'gold') and eval_sample.gold:
    #             prompt = self.tokenizer.decode(encoded_candidates[0])
    #             gold = eval_sample.gold
    #             #input_text = prompt + gold
    #             gold_text = gold[0] if isinstance(gold, list) else gold
    #             input_text = prompt + gold_text
    #             inputs = self.tokenizer(input_text, return_tensors="pt").to(self.model.device)
    #             input_ids = inputs["input_ids"]
    #             labels = input_ids.clone()
    #             labels[labels == self.tokenizer.pad_token_id] = -100

    #             with torch.no_grad():
    #                 loss = self.model(input_ids=input_ids, labels=labels).loss
                    
    #                 if hasattr(self, "eval_loss_list"):
    #                     self.eval_loss_list.append(loss.item())

    #         if verbose:
    #             logger.info("=== Prompt ===")
    #             logger.info(self.tokenizer.decode(encoded_candidates[0]))
    #             logger.info(f"Output: {output_text}")

    #         return Prediction(correct_candidate=eval_sample.correct_candidate, predicted_candidate=output_text)

    #     # =============================
    #     # 🔸 Classification / Multiple-choice task
    #     # =============================
    #     else:
    #         # ===== Compute eval loss for first candidate =====
    #         inputs = {
    #             "input_ids": torch.tensor([encoded_candidates[0]]).to(self.model.device),
    #             "labels": torch.tensor([encoded_candidates[0]]).to(self.model.device),
    #             "option_len": [option_lens[0]],
    #         }
    #         with torch.no_grad():
    #             loss = self.forward_wrap_with_option_len(self.model, **inputs, return_dict=True).loss
                
    #             if hasattr(self, "eval_loss_list"):
    #                 self.eval_loss_list.append(loss.item())

    #         # ===== Log-probability prediction =====
    #         for candidate_id, encoded_candidate in enumerate(encoded_candidates):
    #             selected_log_probs = self.forward(encoded_candidate, option_len=option_lens[candidate_id])
    #             if verbose:
    #                 if candidate_id == 0:
    #                     logger.info(f"=== Candidate {candidate_id} ===")
    #                     logger.info(self.tokenizer.decode(encoded_candidate))
    #                 else:
    #                     logger.info(f"=== Candidate {candidate_id} (no context) ===")
    #                     logger.info(self.tokenizer.decode(encoded_candidate).split(self.task.train_sep)[-1])
    #                 logger.info(f"Log probabilities of option tokens: {selected_log_probs}")

    #             if self.args.sfc or self.args.icl_sfc:
    #                 sfc_selected_log_probs = self.forward(sfc_encoded_candidates[candidate_id],
    #                                                     option_len=sfc_option_lens[candidate_id])
    #                 if verbose:
    #                     logger.info(f"=== Candidate {candidate_id} (SFC) ===")
    #                     logger.info(self.tokenizer.decode(sfc_encoded_candidates[candidate_id]).split(self.task.train_sep)[-1])
    #                     logger.info(f"Log probs (SFC): {sfc_selected_log_probs}")
    #             else:
    #                 sfc_selected_log_probs = None

    #             outputs.append({
    #                 "log_probs": selected_log_probs,
    #                 "sfc_log_probs": sfc_selected_log_probs
    #             })

    #         if self.args.sfc or self.args.icl_sfc:
    #             scores = [x['log_probs'].sum().item() - x['sfc_log_probs'].sum().item() for x in outputs]
    #         else:
    #             scores = [x['log_probs'].mean().item() for x in outputs]

    #         if verbose:
    #             logger.info(f"Prediction scores: {scores}")

    #         if isinstance(eval_sample.correct_candidate, list):
    #             correct_candidate_id = [eval_sample.candidates.index(c) for c in eval_sample.correct_candidate]
    #         else:
    #             correct_candidate_id = eval_sample.candidates.index(eval_sample.correct_candidate)

    #         return Prediction(correct_candidate=correct_candidate_id, predicted_candidate=int(np.argmax(scores)))



    def one_step_pred(self, train_samples, eval_sample, verbose=False):
        """
        Return the prediction on the eval sample. In ICL, use train_samples as demonstrations
        """
        verbose = verbose or self.args.verbose
        if verbose:
            logger.info("========= Example =========")
            logger.info(f"Candidate: {eval_sample.candidates}")
            logger.info(f"Correct candidate: {eval_sample.correct_candidate}")

        # Encode (add prompt and tokenize) the sample; if multiple-choice/classification, encode all candidates (options)
        encoded_candidates, option_lens = encode_prompt(
            self.task, self.task.get_template(), train_samples, eval_sample, self.tokenizer,
            max_length=self.args.max_length,
            generation=self.task.generation, max_new_tokens=self.args.max_new_tokens
        )
        

        # Calibration
        if self.args.sfc or self.args.icl_sfc:
            sfc_encoded_candidates, sfc_option_lens = encode_prompt(self.task, self.task.get_template(),
                                                                    train_samples, eval_sample, self.tokenizer,
                                                                    max_length=self.args.max_length,
                                                                    sfc=self.args.sfc, icl_sfc=self.args.icl_sfc,
                                                                    generation=self.task.generation,
                                                                    max_new_tokens=self.args.max_new_tokens
                                                                    )

        outputs = []
        if self.task.generation:
            # For generation tasks, return the autoregressively-generated text
            output_text = self.forward(encoded_candidates[0], generation=True)
            if verbose:
                logger.info("=== Prompt ===")
                logger.info(self.tokenizer.decode(encoded_candidates[0]))
                logger.info(f"Output: {output_text}")
            return Prediction(correct_candidate=eval_sample.correct_candidate, predicted_candidate=output_text)
        else:
            # For classification/multiple-choice, calculate the probabilities of all candidates
            for candidate_id, encoded_candidate in enumerate(encoded_candidates):
                selected_log_probs = self.forward(encoded_candidate, option_len=option_lens[candidate_id])
                if verbose:
                    if candidate_id == 0:
                        logger.info("=== Candidate %d ===" % candidate_id)
                        logger.info(self.tokenizer.decode(encoded_candidate))
                    else:
                        logger.info("=== Candidate %d (without context)===" % candidate_id)
                        logger.info(self.tokenizer.decode(encoded_candidate).split(self.task.train_sep)[-1])
                    logger.info(f"Log probabilities of the option tokens: {selected_log_probs}")

                if self.args.sfc or self.args.icl_sfc:
                    sfc_selected_log_probs = self.forward(sfc_encoded_candidates[candidate_id],
                                                          option_len=sfc_option_lens[candidate_id])
                    if verbose:
                        logger.info("=== Candidate %d (without context) SFC ===" % candidate_id)
                        logger.info(
                            self.tokenizer.decode(sfc_encoded_candidates[candidate_id]).split(self.task.train_sep)[-1])
                        logger.info(f"Log probabilities of the option tokens: {sfc_selected_log_probs}")

                outputs.append({"log_probs": selected_log_probs,
                                "sfc_log_probs": sfc_selected_log_probs if self.args.sfc or self.args.icl_sfc else None})

            if self.args.sfc or self.args.icl_sfc:
                # Calibrated probabilities (surface form competition; https://arxiv.org/pdf/2104.08315.pdf)
                # log p(candidate | input) = log p_lm(candidate | input) - log p_lm(candidate | sfc prompt)
                scores = [x['log_probs'].sum().item() - x['sfc_log_probs'].sum().item() for x in outputs]
            else:
                # (Default) length-normalized log probabilities
                # log p(candidate | input) = log p_lm(candidate | input) / |candidate #tokens|
                scores = [x['log_probs'].mean().item() for x in outputs]

            if verbose:
                logger.info(f"Prediction scores: {scores}")

            if isinstance(eval_sample.correct_candidate, list):
                # For some datasets there are multiple correct answers
                correct_candidate_id = [eval_sample.candidates.index(c) for c in eval_sample.correct_candidate]
            else:
                correct_candidate_id = eval_sample.candidates.index(eval_sample.correct_candidate)

            return Prediction(correct_candidate=correct_candidate_id, predicted_candidate=int(np.argmax(scores)))

































