from absl import flags
from hasac.envs.smac.smac_logger import SMACLogger
from hasac.envs.smacv2.smacv2_logger import SMACv2Logger
from hasac.envs.mamujoco.mamujoco_logger import MAMuJoCoLogger
from hasac.envs.pettingzoo_mpe.pettingzoo_mpe_logger import PettingZooMPELogger
from hasac.envs.gym.gym_logger import GYMLogger
from hasac.envs.football.football_logger import FootballLogger
from hasac.envs.dexhands.dexhands_logger import DexHandsLogger
from hasac.envs.lag.lag_logger import LAGLogger

FLAGS = flags.FLAGS
FLAGS(["train_sc.py"])

LOGGER_REGISTRY = {
    "smac": SMACLogger,
    "mamujoco": MAMuJoCoLogger,
    "pettingzoo_mpe": PettingZooMPELogger,
    "gym": GYMLogger,
    "football": FootballLogger,
    "dexhands": DexHandsLogger,
    "smacv2": SMACv2Logger,
    "lag": LAGLogger,
}
